package com.aote.webmeter.common.basic.manage;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.manage.param.SaveInstructParam;
import com.aote.webmeter.common.basic.manage.param.SetInstructStateParam;
import com.aote.webmeter.common.dao.InstructDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 指令管理
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class InstructManage {

    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);

    private final SqlServer sqlServer;

    private final EntityServer entityServer;

    private final InstructDao instructDao;

    private final UserFilesDao userFilesDao;

    public InstructManage(SqlServer sqlServer, EntityServer entityServer, InstructDao instructDao, UserFilesDao userFilesDao) {
        this.sqlServer = sqlServer;
        this.entityServer = entityServer;
        this.instructDao = instructDao;
        this.userFilesDao = userFilesDao;
    }

    /**
     * 生成物联网表指令
     * @return 生成的指令ID
     */
    public String save(String userId, SaveInstructParam param) throws Exception {
        //查询用户档案，获取生成指令所需的信息
        JSONArray userFilesInfo = userFilesDao.getMeterInfoByCreateInstruct(userId, param.getF_alias(),null);
        //对冗余指令进行处理
        if(param.getF_inputtor() != InstructInputtorEnum.SYSTEM_DEFAULT &&
                param.getF_inputtor() != InstructInputtorEnum.CHARGE){
            if(param.getF_instruct_type() == InstructTypeEnum.ValveControl){
                instructDao.updateRedundancyValveControlInstruct(userId);
            } else {
                instructDao.updateRedundancyOtherInstruct(userId, param.getF_instruct_type(), param.getF_instruct_title());
            }
        }
        //获取表具信息
        JSONObject userFiles = userFilesInfo.getJSONObject(0);
        //组织指令实体
        InstructEntity instructData = new InstructEntity.Builder(param, userFiles).build();
        //获取指令表名称
        String tableName = CompatTools.getInstructTableName();
        //组织保存指令
        JSONObject instruct = JsonTools.convertToJson(entityServer.partialSaveByEntity(tableName, instructData));
        LOGGER.info("--------{}指令保存成功--------",param.getF_instruct_type().getValue());
        return String.valueOf(instruct.get("id"));
    }

    /**
     * 设置指令执行状态
     * @return 影响的指令行数
     */
    public int setInstructState(SetInstructStateParam param){
        //SQL条件表达式
        String condition;
        if(param.getId() != null){
            condition = "id = '" + param.getId() + "'";
        } else if(param.getCommandId() != null){
            condition = "f_commandId = '" + param.getCommandId() + "'";
        } else {
            condition = param.getCondition();
        }
        //SQL片段 更新指令发送，响应时间
        String sendDateSql = "";
        String callBackDateSql = "";
        switch (param.getState()){
            case SUCCESSFUL:
            case FAILED:
                String now = DateTools.getNow2();
                sendDateSql = "f_send_date = isnull(f_send_date,'"+now+"'), \n";
                callBackDateSql = "f_callback_date = '"+now+"', \n";
                break;
            case ALREADY_SENT:
                sendDateSql = "f_send_date = '"+DateTools.getNow2()+"', \n";
                break;
        }
        //上表信息
        String receiveMsg = param.getReceiveMsg() == null ? param.getState().getReceiveMsg() : param.getReceiveMsg();
        //SQL片段 更新指令元数据
        String metaData;
        if(param.getMetaData() == null) {
            metaData = "isnull(f_instruct_meta_data,f_instruct_content)";
        } else {
            metaData = "'"+param.getMetaData()+"'";
        }
        //SQL片段 更新指令唯一标识
        String syncCommandIdSql;
        if(param.getSyncCommandId() == null) {
            syncCommandIdSql = "isnull(f_commandId,id)";
        } else {
            syncCommandIdSql = "'"+param.getSyncCommandId()+"'";
        }
        //获取指令表名称
        String tableName = CompatTools.getInstructTableName();
        return sqlServer.runSQL("UPDATE {} SET \n" +
                        "F_INSTRUCT_STATE = '{}', \n" +
                        "F_RECEIVE_STATE = '{}', \n" +
                        "{}" +
                        "{}" +
                        "F_INSTRUCT_META_DATA = {}, \n" +
                        "F_COMMANDID = {} \n" +
                        "WHERE {} ",
                tableName,param.getState().getValue(),receiveMsg,
                sendDateSql,callBackDateSql,metaData,syncCommandIdSql,condition);
    }
}
