/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceAlarmStrategyHelper {
    private static final Map<String, Map<String, String>> alarmItemMap = new HashMap<String, Map<String, String>>(5);

    public static JSONArray getAlarmItems(String tableName) {
        Map<String, String> itemMap = alarmItemMap.get(tableName);
        JSONArray result = new JSONArray(itemMap.size());
        itemMap.forEach((key, value) -> {
            JSONObject item = new JSONObject();
            item.put("label", value);
            item.put("value", key);
            result.put((Object)item);
        });
        return result;
    }

    public static String getAlarmItem(String tableName, String alarmItemValue) {
        Map<String, String> itemMap = alarmItemMap.get(tableName);
        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
            if (!entry.getKey().equals(alarmItemValue)) continue;
            return entry.getValue();
        }
        return alarmItemValue;
    }

    static {
        LinkedHashMap<String, String> deviceCommonMap = new LinkedHashMap<String, String>(1);
        deviceCommonMap.put("loseContactDay", "\u5931\u8054\u5929\u6570");
        alarmItemMap.put("deviceCommonMap", deviceCommonMap);
        LinkedHashMap<String, String> meterCommonMap = new LinkedHashMap<String, String>(1);
        meterCommonMap.put("loseContactDay", "\u5931\u8054\u5929\u6570");
        alarmItemMap.put("meterCommonMap", meterCommonMap);
        LinkedHashMap<String, String> t_meteread_map = new LinkedHashMap<String, String>(5);
        t_meteread_map.put("f_jval", "\u8868\u7aef\u5269\u4f59\u91d1\u989d");
        t_meteread_map.put("f_batterylevel", "\u7535\u538b");
        t_meteread_map.put("f_signal", "\u4fe1\u53f7\u5f3a\u5ea6");
        t_meteread_map.put("flowmetertemperature", "\u6e29\u5ea6");
        t_meteread_map.put("flowmeterpressure", "\u538b\u529b");
        t_meteread_map.put("f_magneticInterference", "\u78c1\u5e72\u6270");
        t_meteread_map.put("f_alarmShutValve", "\u62a5\u8b66\u5173\u9600");
        t_meteread_map.put("f_cycleShutValue", "\u5468\u671f\u5173\u9600");
        t_meteread_map.put("f_arrearsShutValue", "\u6b20\u8d39\u5173\u9600");
        t_meteread_map.put("f_gasShutValue", "\u672a\u7528\u6c14\u5173\u9600");
        t_meteread_map.put("f_overCurrentProtection", "\u8fc7\u6d41\u4fdd\u62a4\u5173\u9600");
        t_meteread_map.put("f_LowLithiumBattery", "\u5916\u90e8\u4f4e\u7535");
        t_meteread_map.put("f_LostLithiumBattery", "\u5916\u90e8\u6389\u7535");
        t_meteread_map.put("f_LowLithiumBattery2", "\u5185\u90e8\u4f4e\u7535");
        t_meteread_map.put("f_timesException", "\u91c7\u6837\u65f6\u949f\u5f02\u5e38");
        t_meteread_map.put("f_die_meter", "\u6b7b\u8868");
        t_meteread_map.put("f_die_meter_2", "\u6b7b\u88682");
        t_meteread_map.put("f_LackOfGasFlag", "\u6b20\u91cf");
        t_meteread_map.put("f_wireCloseValveState", "\u65e0\u7ebf\u5173\u9600");
        t_meteread_map.put("f_leakageFlag", "\u5173\u9600\u8d70\u6c14");
        t_meteread_map.put("f_gas_leakage", "\u71c3\u6c14\u6cc4\u9732");
        t_meteread_map.put("f_valve_exception", "\u9600\u95e8\u76f4\u901a");
        t_meteread_map.put("f_SplitAlarm", "\u62c6\u8868\u62a5\u8b66");
        t_meteread_map.put("f_valve_state", "\u9600\u95e8\u62a5\u8b66");
        t_meteread_map.put("f_abnormal_flow", "\u8ba1\u91cf\u6a21\u5757\u5f02\u5e38");
        t_meteread_map.put("forceSafeCheckFlag", "\u5f3a\u5236\u5b89\u68c0\u72b6\u6001");
        t_meteread_map.put("forceSraptFlag", "\u5f3a\u5236\u62a5\u5e9f\u72b6\u6001");
        alarmItemMap.put("t_meteread", t_meteread_map);
        LinkedHashMap<String, String> t_pressure_monitor_read_map = new LinkedHashMap<String, String>(10);
        t_pressure_monitor_read_map.put("f_hsp", "\u7ba1\u9053\u6c14\u4f53\u7684\u76f8\u5bf9\u538b\u529b(Kpa)");
        t_pressure_monitor_read_map.put("f_hst", "\u7ba1\u9053\u6c14\u4f53\u7684\u6e29\u5ea6(\u2103)");
        t_pressure_monitor_read_map.put("f_hsdy", "\u4f20\u611f\u5668\u7535\u6c60\u7535\u538b(V)");
        t_pressure_monitor_read_map.put("f_hsdl", "\u4f20\u611f\u5668\u7535\u6c60\u7535\u91cf(%)");
        t_pressure_monitor_read_map.put("f_hstv", "\u592a\u9633\u80fd\u7535\u6c60\u7535\u538b(V)");
        t_pressure_monitor_read_map.put("f_hsta", "\u592a\u9633\u80fd\u7535\u6c60\u7535\u6d41(mA)");
        t_pressure_monitor_read_map.put("f_hstt", "\u592a\u9633\u80fd\u7535\u6c60\u6e29\u5ea6(\u2103)");
        t_pressure_monitor_read_map.put("f_hsdv", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u7535\u538b(V)");
        t_pressure_monitor_read_map.put("f_hsda", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u7535\u6d41(mA)");
        t_pressure_monitor_read_map.put("f_hsdt", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u6e29\u5ea6(\u2103)");
        alarmItemMap.put("t_pressure_monitor_read", t_pressure_monitor_read_map);
        LinkedHashMap<String, String> t_pressure_transmitters_read_map = new LinkedHashMap<String, String>(6);
        t_pressure_transmitters_read_map.put("flowmeterpressure", "\u538b\u529b\u503c");
        t_pressure_transmitters_read_map.put("flowmetertemperature", "\u6e29\u5ea6\u503c");
        t_pressure_transmitters_read_map.put("f_highpressur", "\u538b\u529b\u91cf\u7a0b\u9ad8");
        t_pressure_transmitters_read_map.put("f_lowpressure", "\u538b\u529b\u91cf\u7a0b\u4f4e");
        t_pressure_transmitters_read_map.put("f_hightemperature", "\u6e29\u5ea6\u91cf\u7a0b\u9ad8");
        t_pressure_transmitters_read_map.put("f_lowtemperature", "\u6e29\u5ea6\u91cf\u7a0b\u4f4e");
        alarmItemMap.put("t_pressure_transmitters_read", t_pressure_transmitters_read_map);
        LinkedHashMap t_wireless_detector_read_map = new LinkedHashMap(1);
        alarmItemMap.put("t_wireless_detector_read", t_wireless_detector_read_map);
        LinkedHashMap<String, String> t_t_wei_ge_read_map = new LinkedHashMap<String, String>(1);
        t_t_wei_ge_read_map.put("flowmeterpressure", "\u538b\u529b");
        alarmItemMap.put("t_wei_ge_read", t_t_wei_ge_read_map);
    }
}

