package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 操作人角色类型
 * @author Mr.river
 */
public enum InstructInputtorEnum {
    SYSTEM_DEFAULT("系统生成"),
    SYSTEM_REQUISITE("系统必需"),
    CHARGE("系统充值"),
    HAND_PLAN("系统抄表"),
    SYSTEM_FILES_LIFE_CYCLE("系统档案流程"),
    OTHER("其他");

    private String value;

    InstructInputtorEnum(String value) {
        this.value = value;
    }

    public static InstructInputtorEnum toType(String value) {
        return Stream.of(InstructInputtorEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(InstructInputtorEnum.OTHER.setValue(value));
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }

    private InstructInputtorEnum setValue(String value){
        this.value = value;
        return this;
    }
}
