-- 公共SQL：生成调价指令（适用SilverLight2，用于直接使用气价明细调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    c.id                       id,
    -- 表档案ID
    u.id                       userid,
    -- 表号
    u.f_meternumber,
    -- 卡号
    ISNULL(u.f_cardid, u.f_meternumber)           f_card_id,
    -- 气价ID
    ui.f_price_id              stairid,
    -- 价格版本
    ISNULL(u.version, 1)       priceversion,
    -- 阶梯周期（月）
    ISNULL(ui.f_stairmonths, 1) f_stairmonths,
    -- 阶梯气价
    ui.f_stair1price,
    ui.f_stair2price,
    ui.f_stair3price,
    -- 阶梯气量
    ui.f_stair1amount,
    ui.f_stair2amount,
    ui.f_stair3amount,
    -- 结算类型（按金额，按气量）
    '按金额' f_collection_type
FROM t_changestairprice c
    LEFT JOIN t_stairprice s ON s.f_stairtype = c.f_stairtype
    LEFT JOIN t_userinfo ui ON ui.f_price_id = s.id
    LEFT JOIN t_userfiles u ON u.f_userinfoid = ui.f_userid
WHERE (c.${setPriceSync} IS NULL or c.${setPriceSync} = '未同步')
  AND u.f_aliasname = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND ui.f_price_id > 0
  AND u.f_userstate = '正常'
  AND c.id =
      (SELECT MAX(id) FROM t_changestairprice ca where c.f_stairtype = ca.f_stairtype)
