package com.aote.webmeter.mq;

import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.annotation.Autowired;

import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * Logic请求消费监听
 */
public class LogicMessageListener implements MessageListenerConcurrently {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = Logger.getLogger(LogicMessageListener.class);
    @Autowired
    private LogicService logicService;

    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        for (MessageExt msg : msgs) {
            try {
                //消费Logic请求
                String logicName = msg.getTags();
                String body = new String(msg.getBody(), StandardCharsets.UTF_8);
                runLogic(logicName,body);
            } catch (Throwable e) {
                e.printStackTrace();
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        }
        // 如果没有异常会认为都成功消费
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    private void runLogic(String logicName, String data) {
        try {
            logicService.xtSave(logicName, data);
        } catch (Exception e) {
            LOGGER.error("【" + logicName + "】出现异常：", e);
        }
    }
}
