package com.aote.webmeter.common.template.builder.impl.saveInstruct;

import com.aote.webmeter.common.basic.pour.PourSaveLogic;
import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.common.template.member.saveInstruct.SaveOpenAccountTemplate;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import lombok.Getter;
import org.json.JSONObject;

/**
 * 保存开户指令模板-构造器
 * @author Mr.river
 */
@Getter
public class SaveOpenAccountTemplateBuilder extends SaveInstructTemplateBuilder {

    private Boolean isSellUpdate = false;

    protected SaveOpenAccountTemplateBuilder(JSONObject entity, PourSaveLogic pourSaveLogic) {
        super(entity, InstructTypeEnum.OpenAccount, pourSaveLogic);
        this.setInputtor(InstructInputtorEnum.SYSTEM_FILES_LIFE_CYCLE);
        setTitleAndDataIdByIsSellUpdate();
    }

    public static SaveOpenAccountTemplateBuilder create(JSONObject entity, PourSaveLogic pourSaveLogic) {
        return new SaveOpenAccountTemplateBuilder(entity, pourSaveLogic);
    }

    @Override
    public SaveOpenAccountTemplate build() {
        return SpringBeanUtil.getBean(SaveOpenAccountTemplate.class,this);
    }

    /**
     * @param sellUpdate 是否将第一次充值作为开户
     * @apiNote 默认false，部分表具开户时需要带充值，对于这种情况，需要在开户指令生成后，更新充值指令的同步状态
     * @see PourSaveLogic#run(JSONObject)
     */
    public SaveOpenAccountTemplateBuilder setSellUpdate(Boolean sellUpdate) {
        isSellUpdate = sellUpdate;
        setTitleAndDataIdByIsSellUpdate();
        return this;
    }

    /**
     * 根据是否将第一次充值作为开户，调整指令的标题和映射数据ID
     */
    private void setTitleAndDataIdByIsSellUpdate(){
        //设置指令标题
        if(isSellUpdate){
            this.setTitle("开户充值");
            this.setDataId(String.valueOf(this.getEntity().get("sellid")));
        } else {
            this.setTitle("开户建档");
            this.setDataId(this.getUserId());
        }
    }
}
