package com.aote.webmeter.common.basic.param;

import com.aote.webmeter.common.basic.builder.SetInstructStateParamBuilder;
import com.aote.webmeter.enums.InstructStateEnum;
import lombok.Getter;

/**
 * 设置指令状态参数
 */
@Getter
public class SetInstructStateParam {
    private final String id;
    private final String commandId;
    private final String condition;
    private final InstructStateEnum state;
    private final String metaData;
    private final String receiveMsg;
    private final String syncCommandId;

    public SetInstructStateParam(SetInstructStateParamBuilder builder) {
        this.id = builder.getId();
        this.commandId = builder.getCommandId();
        this.condition = builder.getCondition();
        this.state = builder.getState();
        this.metaData = builder.getMetaData();
        this.receiveMsg = builder.getReceiveMsg();
        this.syncCommandId = builder.getSyncCommandId();
    }
}
