package com.aote.webmeter.tools.iot.aep;

import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceResponse;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceResponse;
import org.json.JSONArray;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * 设备管理
 * @author 物联网小组
 */
public class DeviceManager {


    /**
     * 创建新设备
     * @param deviceName 设备名称，必填
     * @param deviceSn 设备编号，MQTT,T_Link,TCP,HTTP,JT/T808，南向云协议必填
     * @param imei imei号，LWM2M,NB网关协议必填
     * @param other LWM2M协议必填参数,其他协议不填：{
     *       autoObserver:0.自动订阅 1.取消自动订阅，必填;
     *       imsi:总长度不超过15位，使用0~9的数字，String类型,选填;
     *       pskValue:由大小写字母加0-9数字组成的16位字符串,选填
     * @return 响应结果
     */
    public static JSONObject createDevice(String deviceName, String deviceSn, String imei, JSONObject other) {
        //获取设备管理客户端
        AepDeviceManagementClient client = ClientFactory.getAepDeviceManagementClient();

        try {
            //实例化创建设备请求
            CreateDeviceRequest request = new CreateDeviceRequest();

            //设置请求参数
            request.setParamMasterKey(WebMeterInfo.getString("MasterKey"));

            //设置请求体
            JSONObject paramsBody = new JSONObject();
            paramsBody.put("deviceName", deviceName);
            paramsBody.put("deviceSn", deviceSn);
            paramsBody.put("imei", imei);
            paramsBody.put("operator", "admin");
            paramsBody.put("other", other);
            paramsBody.put("productId", WebMeterInfo.getString("productId"));
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));

            //发起请求
            CreateDeviceResponse response = client.CreateDevice(request);

            //返回结果
            return new JSONObject(new String(response.getBody(), StandardCharsets.UTF_8));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 删除批量设备
     * @param deviceIds 需要删除的设备ID集合
     * @return 响应结果
     */
    public static JSONObject deleteDevice(JSONArray deviceIds) {
        //获取设备管理客户端
        AepDeviceManagementClient client = ClientFactory.getAepDeviceManagementClient();

        try {
            //实例化删除设备请求
            DeleteDeviceRequest request = new DeleteDeviceRequest();

            //设置请求参数
            request.setParamMasterKey(WebMeterInfo.getString("MasterKey"));
            request.setParamProductId(WebMeterInfo.getString("productId"));
            request.setParamProductId(WebMeterInfo.getString("deviceIds"));

            //遍历需要删除的设备ID集合，拼接出需要删除的设备字符串(A,B,C,D)
            StringBuilder deviceIdsString = new StringBuilder();
            deviceIds.forEach((item)-> deviceIdsString.append(item).append(","));
            deviceIdsString.deleteCharAt(deviceIdsString.length() - 1);
            request.setParamDeviceIds(deviceIdsString.toString());

            //发起请求,并且返回结果
            DeleteDeviceResponse response = client.DeleteDevice(request);

            //将返回的结果返回
            return new JSONObject(new String(response.getBody(), StandardCharsets.UTF_8));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

}
