package com.aote.webmeter.tools;

import com.af.plugins.CommonTools;
import com.aote.webmeter.enums.ModuleEnum;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.exception.WebmeterException;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

/**
 * 物联网表配置文件读取工具
 * @author Mr.river
 */

public class WebmeterPropertiesTools {
	/**
	 * 根据指定路径和模块名获取物联网表配置文件
	 * @param path 模块路径
	 * @param moduleName 模块名
	 * @return 对应的配置文件JSON
	 */
	public static HashMap<String,String> readWebMeter(String path, String moduleName){
		if(!"".equals(moduleName)){
			if(!"".equals(path)) {
				path = "/" + path;
			}
			path = path + "/" + moduleName + "/webmeter.properties";
		} else {
			path = "webmeter.properties";
		}
		Properties props = new Properties();
		InputStream proStream = WebmeterPropertiesTools.class.getClassLoader().getResourceAsStream(path);
		if (proStream == null) {
			return null;
		}
		InputStreamReader propertiesAsStream = new InputStreamReader(proStream);
		try {
			props.load(propertiesAsStream);
		} catch (IOException e) {
			throw new WebmeterException(WebmeterExceptionCodeEnum.CONFIG_FAIL, "模块：" + moduleName);
		}
		Set<Object> keys = props.keySet();
		HashMap<String, String> params = new HashMap<>(keys.size());
		for (Object k : keys) {
			String keyStr = k.toString();
			//格式化参数字符串
			String value = CommonTools.parametricStr(props.getProperty(keyStr), props);
			params.put(keyStr, value);
		}
		return params;
	}

	/**
	 * 根据指定模块名获取物联网表配置文件
	 * @param moduleName 模块名
	 * @return 对应的配置文件JSON
	 */
	public static HashMap<String,String> readWebMeter(String moduleName){
		return readWebMeter("",moduleName);
	}
}
