package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 表档案状态
 * @author Mr.river
 */
public enum MeterTableStateEnum {
    NORMAL("正常"),
    DISABLED("停用"),
    METER_CHANGE("换表");

    private final String value;

    MeterTableStateEnum(String value) {
        this.value = value;
    }

    public static MeterTableStateEnum toType(String value) {
        return Stream.of(MeterTableStateEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
