package com.aote.webmeter.common.template;

import com.aote.webmeter.common.basic.pour.PourRunLogic;
import com.aote.webmeter.common.basic.pour.PourSaveLogic;
import com.aote.webmeter.common.template.builder.impl.runInstruct.RunInstructTemplateBuilder;
import com.aote.webmeter.common.template.builder.impl.saveInstruct.SaveBasicInstructTemplateBuilder;
import com.aote.webmeter.common.template.builder.impl.saveInstruct.SaveGasRechargeTemplateBuilder;
import com.aote.webmeter.common.template.builder.impl.saveInstruct.SaveOpenAccountTemplateBuilder;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.InstructTypeEnum;
import org.json.JSONObject;

public class Templates {

    private Templates() {
        super();
    }

    /**
     * 获取保存基础指令模板构造器
     * @param userId 参考 {@link SaveBasicInstructTemplateBuilder#setUserId(String)}
     * @param type 参考 {@link SaveBasicInstructTemplateBuilder#setType(InstructTypeEnum)}
     * @return 保存指令模板构造器
     */
    public static SaveBasicInstructTemplateBuilder buildSaveBasicInstructTemplate(String userId, InstructTypeEnum type){
        return SaveBasicInstructTemplateBuilder.create(userId, type);
    }

    /**
     * 获取保存开户指令模板构造器
     * @param entity 参考 {@link com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder#setEntity(JSONObject)}
     * @param pourSaveLogic 参考 {@link com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder#setPourSaveLogic(PourSaveLogic)}
     * @return 保存指令模板构造器
     */
    public static SaveOpenAccountTemplateBuilder buildSaveOpenInstructTemplate(JSONObject entity, PourSaveLogic pourSaveLogic){
        return SaveOpenAccountTemplateBuilder.create(entity, pourSaveLogic);
    }

    /**
     * 获取保存充值指令模板构造器
     * @param entity 参考 {@link com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder#setEntity(JSONObject)}
     * @param pourSaveLogic 参考 {@link com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder#setPourSaveLogic(PourSaveLogic)}
     * @return 保存指令模板构造器
     */
    public static SaveGasRechargeTemplateBuilder buildSaveGasRechargeTemplate(JSONObject entity, PourSaveLogic pourSaveLogic){
        return SaveGasRechargeTemplateBuilder.create(entity, pourSaveLogic);
    }

    /**
     * 获取执行指令模板构造器
     * @param instructEntity 参考 {@link RunInstructTemplateBuilder#setInstructEntity(InstructEntity)}
     * @param pourRunLogic 参考 {@link RunInstructTemplateBuilder#setPourRunLogic(PourRunLogic)}
     * @return 执行指令模板构造器
     */
    public static RunInstructTemplateBuilder buildRunInstructTemplate(InstructEntity instructEntity, PourRunLogic pourRunLogic){
        return RunInstructTemplateBuilder.create(instructEntity, pourRunLogic);
    }
}
