-- 公共SQL：生成充值指令（适用V2）
-- 必选参数
-- f_meter_brand：表具品牌别名

SELECT
    -- 业务记录ID
    sell.id,
    -- 旧业务记录ID
    sell.f_old_sell_id,
    -- 表档案ID
    sell.userid,
    -- 表号
    u.f_meternumber,
    -- 充值金额
    sell.payvalue,
    -- 充值气量
    sell.paygasvalue,
    -- 充值次数
    sell.f_times,
    -- 总购金额
    sell.total,
    -- 总购气量
    sell.totalgas,
    -- 结算类型（按金额，按气量）
    g.f_collection_type,
    -- 充值类型
    sell.type
FROM (
    SELECT f.id             id,
           f.f_user_id      userid,
           f.f_meternumber  f_meternumber,
           f.f_fillgas_fee  payValue,
           f.f_fillgas      paygasvalue,
           f.f_times        f_times,
           f.id             f_old_sell_id,
           f.f_total_fee    total,
           f.f_total_gas    totalgas,
           case f.f_fillgas_type
               when '物联网补费' then '补费'
               when '物联网扣费' then '扣费'
               else '换表补气'
               end           type
    FROM t_fillgas f
    WHERE f.f_fillgas_state = '有效'
      AND f.f_sendsuccess IS NULL
    UNION ALL
    SELECT s.id             id,
           s.f_user_id      userid,
           s.f_meternumber  f_meternumber,
           s.f_collection   payValue,
           s.f_pregas       paygasvalue,
           s.f_times        f_times,
           isnull(s.f_old_sell_id,s.id) f_old_sell_id,
           s.f_total_fee    total,
           s.f_total_gas    totalgas,
           case s.f_charge_type
               when '物联网收费' then '充值'
               when '退费' then '退费'
               else '充值/退费'
               end           type
    FROM t_sellinggas s
    WHERE s.f_charge_state = '有效'
      AND s.f_charge_type IN ('物联网收费', '退费')
      AND (s.f_sendsuccess IS NULL or s.f_sendsuccess = '未同步')
    ) sell
    LEFT JOIN t_userfiles u ON u.f_user_id = sell.userId and u.f_meternumber = sell.f_meternumber
    LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
WHERE g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND u.f_table_state = '正常'
ORDER BY sell.f_times
