/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DeviceManagementTools {
    private static final Logger LOGGER = Logger.getLogger(DeviceManagementTools.class);
    private static final String DEVICE_BINDED_1 = "100416";
    private static final String DEVICE_BINDED_2 = "100426";
    private static final String DEVICE_CANCEL_BINDED_1 = "100403";
    private static final String DEVICE_CANCEL_BINDED_2 = "100418";

    public static String regDevice(String nodeId) throws IOException {
        JSONObject content = new JSONObject();
        content.put("nodeId", (Object)nodeId);
        content.put("verifyCode", (Object)nodeId);
        content.put("timeout", 0);
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE, (HttpEntityEnclosingRequestBase)new HttpPost(), content);
        if (result.has("error_code")) {
            if (DEVICE_BINDED_1.equals(result.get("error_code")) || DEVICE_BINDED_2.equals(result.get("error_code"))) {
                return "\u8bbe\u5907\u5df2\u88ab\u6ce8\u518c";
            }
            throw new RuntimeException(result.toString());
        }
        return (String)result.get("deviceId");
    }

    public static String regDevice(String nodeId, String name) throws IOException {
        JSONObject content = new JSONObject();
        content.put("nodeId", (Object)nodeId);
        content.put("verifyCode", (Object)nodeId);
        content.put("timeout", 0);
        content.put("deviceName", (Object)name);
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("manufacturerId", (Object)WebMeterInfo.getString("manuFacturerId"));
        deviceInfo.put("manufacturerName", (Object)WebMeterInfo.getString("manuFacturerName"));
        deviceInfo.put("deviceType", (Object)WebMeterInfo.getString("deviceType"));
        deviceInfo.put("model", (Object)WebMeterInfo.getString("meterModel"));
        deviceInfo.put("protocolType", (Object)"CoAP");
        content.put("deviceInfo", (Object)deviceInfo);
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE, (HttpEntityEnclosingRequestBase)new HttpPost(), content);
        if (result.has("status") && result.getInt("status") == 400) {
            return "\u8bbe\u5907\u5df2\u88ab\u6ce8\u518c";
        }
        if (result.has("error_code")) {
            if (DEVICE_BINDED_1.equals(result.get("error_code")) || DEVICE_BINDED_2.equals(result.get("error_code"))) {
                return "\u8bbe\u5907\u5df2\u88ab\u6ce8\u518c";
            }
            throw new RuntimeException(result.toString());
        }
        return (String)result.get("deviceId");
    }

    public static int modifyDeviceInfo(String deviceId, String name) throws IOException {
        JSONObject content = new JSONObject();
        content.put("name", (Object)name);
        content.put("manuFacturerId", (Object)WebMeterInfo.getString("manuFacturerId"));
        content.put("manuFacturerName", (Object)WebMeterInfo.getString("manuFacturerName"));
        content.put("deviceType", (Object)WebMeterInfo.getString("deviceType"));
        content.put("model", (Object)WebMeterInfo.getString("meterModel"));
        content.put("protocolType", (Object)"CoAP");
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, (HttpEntityEnclosingRequestBase)new HttpPut(), content, deviceId);
        if (result.has("error_code")) {
            throw new RuntimeException(result.toString());
        }
        return 0;
    }

    public static int cancelDevice(String deviceId) throws IOException {
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, (HttpEntityEnclosingRequestBase)new HttpDeleteWithBody(), null, deviceId);
        if (result.has("error_code")) {
            if (DEVICE_CANCEL_BINDED_1.equals(result.get("error_code")) || DEVICE_CANCEL_BINDED_2.equals(result.get("error_code"))) {
                return 0;
            }
            throw new RuntimeException(result.toString());
        }
        return 0;
    }
}

