/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.iotplatform.client.NorthApiException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthenticationTools {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTools.class);
    private static final Map<String, Long> STAMP = new HashMap<String, Long>();
    private static final Map<String, String> AOD = new HashMap<String, String>();
    private static final Integer TOKEN_TIMEOUT_VALUE = 1800000;
    private static String refreshToken = null;
    private static CloseableHttpClient httpClient;

    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            AuthenticationTools.setHttpClient();
        }
        return httpClient;
    }

    private static synchronized void setHttpClient() {
        try {
            httpClient = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)AuthenticationTools.initSslConfig());
        }
        catch (NorthApiException e) {
            e.printStackTrace();
        }
    }

    public static String getAuthToken() {
        String token = AuthenticationTools.getToken();
        if (token != null) {
            return token;
        }
        try {
            return AuthenticationTools.getWebAuthToken();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized String getWebAuthToken() throws IOException {
        String token = AuthenticationTools.getToken();
        if (token == null) {
            JSONObject result;
            String appId = IotCommonTools.getIsAep() != false ? WebMeterInfo.getString("aepAPIKey") : WebMeterInfo.getString("telecomAPIKey");
            String secret = IotCommonTools.getIsAep() != false ? WebMeterInfo.getString("aepSecret") : WebMeterInfo.getString("telecomSecret");
            JSONObject content = new JSONObject();
            content.put("appId", (Object)appId);
            content.put("secret", (Object)secret);
            if (refreshToken == null) {
                LOGGER.info((Object)(appId + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
                result = IotCommonTools.post(IOTBusinessTypeEnum.AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
            } else {
                LOGGER.info((Object)(appId + ":\u8fdb\u884c\u5237\u65b0\u9274\u6743\u64cd\u4f5c"));
                content.put("refreshToken", (Object)refreshToken);
                result = IotCommonTools.post(IOTBusinessTypeEnum.REFRESH_AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
            }
            refreshToken = result.getString("refreshToken");
            String newAccessToken = result.getString("accessToken");
            AOD.put(appId, newAccessToken);
            STAMP.put(appId, System.currentTimeMillis());
            return newAccessToken;
        }
        return token;
    }

    private static String getToken() {
        long current = System.currentTimeMillis();
        String appId = IotCommonTools.getIsAep() != false ? WebMeterInfo.getString("aepAPIKey") : WebMeterInfo.getString("telecomAPIKey");
        String accessToken = AOD.get(appId);
        Long stampValue = STAMP.get(appId);
        if (accessToken != null && stampValue != null && current - stampValue < (long)TOKEN_TIMEOUT_VALUE.intValue()) {
            LOGGER.info((Object)(appId + ":\u83b7\u53d6\u73b0\u6709token"));
            return accessToken;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected static SSLConnectionSocketFactory initSslConfig() throws NorthApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        AuthenticationTools.setHttpClient();
    }
}

