/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.CommonTools;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WebmeterPropertiesTools {
    public static HashMap<String, String> readWebMeter(String path, String moduleName) {
        if (!"".equals(moduleName)) {
            if (!"".equals(path)) {
                path = "/" + path;
            }
            path = path + "/" + moduleName + "/webmeter.properties";
        } else {
            path = "/webmeter.properties";
        }
        Properties props = new Properties();
        InputStream proStream = WebmeterPropertiesTools.class.getResourceAsStream(path);
        if (proStream == null) {
            return null;
        }
        InputStreamReader propertiesAsStream = new InputStreamReader(WebmeterPropertiesTools.class.getResourceAsStream(path + "/" + moduleName + "/webmeter.properties"), StandardCharsets.UTF_8);
        try {
            props.load(propertiesAsStream);
        }
        catch (IOException e) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.CONFIG_FAIL, "\u6a21\u5757\uff1a" + moduleName);
        }
        Set<Object> keys = props.keySet();
        HashMap<String, String> params = new HashMap<String, String>(keys.size());
        for (Object k : keys) {
            String keyStr = k.toString();
            String value = CommonTools.parametricStr((String)props.getProperty(keyStr), (Map)props);
            params.put(keyStr, value);
        }
        return params;
    }

    public static HashMap<String, String> readWebMeter(String moduleName) {
        return WebmeterPropertiesTools.readWebMeter("", moduleName);
    }
}

