package com.aote.webmeter.tools.iot.aep;

import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepMqSubClient;
import com.ctg.ag.sdk.biz.aep_mq_sub.*;
import org.json.JSONArray;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * MQ消息订阅管理
 * @author 物联网小组
 */
public class MqManager {

    /**
     * 增加或修改产品订阅规则
     * @param topicId  主题ID
     * @param productId  产品ID
     * @param subTypes  消息类型int数组，为空则认为可删除
     */
    public static JSONObject changeSubRules(String topicId, int productId, JSONArray subTypes) {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建规则请求对象
            ChangeSubRulesRequest request = new ChangeSubRulesRequest();
            //设置请求体
            JSONObject paramsBody=new JSONObject();
            //主题ID
            paramsBody.put("topicId",topicId);
            //产品ID
            paramsBody.put("productId",productId);
            //消息类型int数组
            paramsBody.put("subTypes",subTypes);
            //将设置好的请求体放入请求对象中
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));
            //发送请求，并且接收响应
            ChangeSubRulesResponse response=client.ChangeSubRules(request);
            //将响应的数据转换为JSON形式返回，并设置编码格式
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 更新topic基本信息，可更新topic名称、描述、启用状态、数据源类型、删除状态
     * @param topicName  topic名称，只能包含字母数字、中/下划线，30字符以内，
     * @param topicDesc  topic描述， 255英文字符以内
     * @param isAllMsg  主题是否包含所有数据源。true(1):是；false(0):否,
     * @param isEnable:该主题是否启用, true(1):是；false(0):否,
     * @param isDel: 该主题是否已删除, true(1):是；false(0):否,
     */
    public static JSONObject changeTopicInfo(String topicName,String topicDesc,int isAllMsg,int isEnable,int isDel) {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建规则请求
            ChangeTopicInfoRequest request = new ChangeTopicInfoRequest();
            //设置请求参数
            request.setParamTopicId(WebMeterInfo.getString("topicId"));
            //设置请求体
            JSONObject paramsBody=new JSONObject();
            paramsBody.put("topicName",topicName);
            paramsBody.put("topicDesc",topicDesc);
            paramsBody.put("isAllMsg",isAllMsg);
            paramsBody.put("isEnable",isEnable);
            paramsBody.put("isDel",isDel);
            //把JSON格式的数据传入请求对象中
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));
            //发送请求，并获得响应结果
            ChangeTopicInfoResponse response=client.ChangeTopicInfo(request);
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;

    }

    /**
     * 关闭租户MQ消息提送服务
     */
    public static JSONObject closePushService() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建关闭服务推送请求
            ClosePushServiceRequest request = new ClosePushServiceRequest();
            //发动请求，并接受响应对象
            ClosePushServiceResponse response=client.ClosePushService(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 创建topic，同一租户最多能创建10个主题，不能出现同名topic
     * @param topicName  topic名称（必填），只能包含字母数字、中/下划线，30字符以内，
     * @param topicDesc  topic描述（必填）， 255英文字符以内
     */
    public static JSONObject createTopic(String topicName,String topicDesc){
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建topic请求
            CreateTopicRequest request=new CreateTopicRequest();
            //设置请求体
            JSONObject paramsBody=new JSONObject();
            paramsBody.put("topicName",topicName);
            paramsBody.put("topicDesc",topicDesc);
            //将请求体传入请求对象
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));
            //发动请求，并接受响应对象
            CreateTopicResponse response=client.CreateTopic(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 开通租户MQ消息推送服务
     */
    public static JSONObject openMqService() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建开通消息服务请求
            OpenMqServiceRequest request=new OpenMqServiceRequest();
            //发动请求，并接受响应对象
            OpenMqServiceResponse response=client.OpenMqService(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 根据tenantId查询开通状态、开通时间、token等信息
     */
    public static JSONObject queryServiceState() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建查询状态请求
            QueryServiceStateRequest request=new QueryServiceStateRequest();
            //发动请求，并接受响应对象
            QueryServiceStateResponse response=client.QueryServiceState(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 根据产品ID获取指定topic下的订阅规则列表，支持多产品ID
     *
     * @param productIds  产品id（必填），为int数组，
     * @param topicId    主题id（必填）
     */
    public static JSONObject querySubRules(JSONArray productIds, String topicId){
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建查询请求
            QuerySubRulesRequest request=new QuerySubRulesRequest();
            //设置请求体
            JSONObject paramsBody=new JSONObject();
            paramsBody.put("productIds",productIds);
            paramsBody.put("topicId",topicId);
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));
            //发动请求，并接受响应对象
            QuerySubRulesResponse response=client.QuerySubRules(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 根据topicId查询topic缓存空间使用信息
     */
    public static JSONObject queryTopicCacheInfo() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建查询请求
            QueryTopicCacheInfoRequest  request=new QueryTopicCacheInfoRequest ();
            //设置请求参数
            request.setParamTopicId(WebMeterInfo.getString("topicId"));
            //发送请求，并接受响应对象
            QueryTopicCacheInfoResponse response=client.QueryTopicCacheInfo(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 根据topicId查询topic基本信息
     */
    public static JSONObject queryTopicInfo() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建查询请求
            QueryTopicInfoRequest   request=new QueryTopicInfoRequest  ();
            //设置请求参数
            request.setParamTopicId(WebMeterInfo.getString("topicId"));
            //发送请求，并接受响应对象
            QueryTopicInfoResponse response=client.QueryTopicInfo(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 查询某个租户的所有topic列表
     */
    public static JSONObject queryTopics() {
        //获得MQ队列客户端
        AepMqSubClient client = ClientFactory.getAepMqSubClient();

        try {
            //创建查询请求
            QueryTopicsRequest request=new QueryTopicsRequest();
            //发送请求，并接受响应对象
            QueryTopicsResponse response=client.QueryTopics(request);
            //将响应的值转换为JSON然后返回
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }
}
