package com.aote.webmeter.common.template.member.saveInstruct;

import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.CompatTools;
import lombok.AccessLevel;
import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Getter(AccessLevel.PROTECTED)
@Template
public class SaveGasRechargeTemplate extends SaveInstructTemplate {

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveGasRechargeTemplate.class);

    public SaveGasRechargeTemplate(SaveInstructTemplateBuilder builder) {
        super(builder);
    }

    @Override
    public void afterExec() {
        super.afterExec();
        String type = String.valueOf(this.getEntity().get("type"));
        //更新充值记录
        switch (type){
            case "充值":
            case "退费":
            case "充值/退费":
                sqlServer.run(CompatTools.getUpdateChargeMeterSql(this.getDataId()));
                break;
            case "冲正":
                sqlServer.run(CompatTools.getUpdateCancelChargeMeterSql(this.getDataId()));
                break;
            case "补费扣费":
                sqlServer.run(CompatTools.getUpdateAdjustMoneyMeterSql(this.getDataId()));
                break;
            case "换表补气":
            case "补扣费/换表":
                sqlServer.run(CompatTools.getUpdateSupplyGasMeterSql(this.getDataId()));
                break;
            default:
                throw new WebmeterException(BusinessExceptionCodeEnum.INVALID_RECHARGE_SOURCE_TYPE,"充值源信息："+ type);
        }
    }
}
