package com.aote.webmeter.common.template.builder.impl.saveInstruct;

import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.common.template.member.saveInstruct.SaveInstructTemplate;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 保存基础指令模板-构造器
 * @author Mr.river
 */
@Getter
@Setter(AccessLevel.PUBLIC)
@Accessors(chain = true)
public class SaveBasicInstructTemplateBuilder extends SaveInstructTemplateBuilder {

    private String userId;
    private InstructTypeEnum type;
    private String content;
    private String dataId;
    private String title;
    private String alias;
    private InstructInputtorEnum inputtor = InstructInputtorEnum.SYSTEM_DEFAULT;
    private String moduleName;

    protected SaveBasicInstructTemplateBuilder(String userId, InstructTypeEnum type) {
        super(userId, type);
    }

    public static SaveBasicInstructTemplateBuilder create(String userId, InstructTypeEnum type) {
        return new SaveBasicInstructTemplateBuilder(userId, type);
    }

    @Override
    public SaveInstructTemplate build() {
        return SpringBeanUtil.getBean(SaveInstructTemplate.class,this);
    }
}
