package com.aote.webmeter.common.basic.manage;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.param.SaveInstructParam;
import com.aote.webmeter.common.basic.param.SetInstructStateParam;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 指令管理
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class InstructManage {

    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    private EntityServer entityServer;

    /**
     * 生成物联网表指令
     * @return 生成的指令ID
     */
    public String save(SaveInstructParam param) throws Exception {
        LOGGER.info("--------保存{}指令--------",param.getType().getValue());
        //获取营收系统版本名
        SaleVersionEnum saleName = WebMeterInfo.getSaleNameEnum();
        //获取查询档案信息的SQL名称
        String sqlName = param.getMeterInfoSql();
        if(sqlName == null){
            switch (saleName){
                case SILVER_LIGHT:
                    sqlName = "yinGuangGetMeterInfoBySaveInstruct";
                    break;
                case SILVER_LIGHT2:
                    sqlName = "yinGuangGetMeterInfo2BySaveInstruct";
                    break;
                default:
                    sqlName = "getMeterInfoBySaveInstruct";
                    break;
            }
        }
        //气表品牌别名，如果没有传入，则取配置文件的名称
        String meterBrandName = param.getMeterBrandName() == null ?
                WebMeterInfo.getString("meterBrandName") : param.getMeterBrandName();
        //获取查询档案信息的条件表达式
        String condition = param.getCondition() == null ? CompatTools.getBasicCondition(param.getUserId()) : param.getCondition();
        //查询用户档案，获取生成指令所需的信息
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("f_meter_brand",meterBrandName);
        sqlParams.put("condition",condition);
        JSONArray userFilesInfo = sqlServer.query(sqlName,sqlParams);
        if(userFilesInfo.length() == 0) {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_NOT_FIND,condition);
        } else if(userFilesInfo.length() > 1) {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_FIND_MULTIPLE,condition);
        } else {
            //获取表具信息
            JSONObject userFiles = userFilesInfo.getJSONObject(0);
            //组织指令实体
            InstructEntity instructData = InstructEntity.build(userFiles);
            instructData.setF_instruct_type(param.getType().getValue());
            instructData.setF_alias(meterBrandName);
            instructData.setF_instruct_title(param.getTitle());
            instructData.setF_instruct_state(param.getState().getValue());
            instructData.setF_instruct_content(param.getContentData());
            instructData.setF_inputtor(param.getInputtor().getValue());
            instructData.setF_info(param.getReasonInfo());
            instructData.setF_meteread_id(param.getMetereadId());
            instructData.setF_data_id(param.getDataId());
            instructData.setF_receive_state(param.getState().getReceiveMsg());
            //表号
            String meterNumber = instructData.getF_meternumber();
            //获取指令表名称
            String tableName = CompatTools.getInstructTableName();
            //清理冗余指令
            cleanRedundancyInstruct(param.getType(),param.getInputtor(),tableName,param.getTitle(),meterNumber);
            //组织保存指令
            JSONObject instruct = JsonTools.convertToJson(entityServer.partialSaveByEntity(tableName, instructData));
            LOGGER.info("--------{}指令保存成功--------",param.getType().getValue());
            return String.valueOf(instruct.get("id"));
        }
    }

    /**
     * 设置指令执行状态
     * @return 影响的指令行数
     */
    public int setInstructState(SetInstructStateParam param){
        //SQL条件表达式
        String condition;
        if(param.getId() != null){
            condition = "id = '" + param.getId() + "'";
        } else if(param.getCommandId() != null){
            condition = "f_commandId = '" + param.getCommandId() + "'";
        } else {
            condition = param.getCondition();
        }
        //SQL片段 更新指令发送，响应时间
        String sendDateSql = "";
        String callBackDateSql = "";
        switch (param.getState()){
            case SUCCESSFUL:
            case FAILED:
                String now = DateTools.getNow2();
                sendDateSql = "f_send_date = isnull(f_send_date,'"+now+"'), \n";
                callBackDateSql = "f_callback_date = '"+now+"', \n";
                break;
            case ALREADY_SENT:
                sendDateSql = "f_send_date = '"+DateTools.getNow2()+"', \n";
                break;
        }
        //上表信息
        String receiveMsg = param.getReceiveMsg() == null ? param.getState().getReceiveMsg() : param.getReceiveMsg();
        //SQL片段 更新指令元数据
        String metaData;
        if(param.getMetaData() == null) {
            metaData = "isnull(f_instruct_meta_data,f_instruct_content)";
        } else {
            metaData = "'"+param.getMetaData()+"'";
        }
        //SQL片段 更新指令唯一标识
        String syncCommandIdSql;
        if(param.getSyncCommandId() == null) {
            syncCommandIdSql = "isnull(f_commandId,id)";
        } else {
            syncCommandIdSql = "'"+param.getSyncCommandId()+"'";
        }
        //获取指令表名称
        String tableName = CompatTools.getInstructTableName();
        return sqlServer.runSQL("UPDATE {} SET \n" +
                        "F_INSTRUCT_STATE = '{}', \n" +
                        "F_RECEIVE_STATE = '{}', \n" +
                        "{}" +
                        "{}" +
                        "F_INSTRUCT_META_DATA = {}, \n" +
                        "F_COMMANDID = {} \n" +
                        "WHERE {} ",
                tableName,param.getState().getValue(),receiveMsg,
                sendDateSql,callBackDateSql,metaData,syncCommandIdSql,condition);
    }

    /**
     * 清理冗余指令
     */
    private void cleanRedundancyInstruct(InstructTypeEnum type,InstructInputtorEnum inputtor,
                                         String tableName,String title,String meterNumber){
        //对冗余指令进行处理
        if(inputtor != InstructInputtorEnum.SYSTEM_DEFAULT &&
                inputtor != InstructInputtorEnum.CHARGE &&
                inputtor != InstructInputtorEnum.HAND_PLAN){
            if(type == InstructTypeEnum.ValveControl){
                if(inputtor == InstructInputtorEnum.SYSTEM_REQUISITE){
                    sqlServer.run("UPDATE {} SET f_instruct_state='忽略冗余' " +
                            "WHERE F_INSTRUCT_STATE = '待发送' " +
                            "AND F_METERNUMBER = '{}' " +
                            "AND F_INSTRUCT_TYPE = '阀门控制' ",tableName,meterNumber);
                } else {
                    sqlServer.run("UPDATE {} SET f_instruct_state='忽略冗余'" +
                            "WHERE F_INSTRUCT_STATE = '待发送' " +
                            "AND F_METERNUMBER = '{}' " +
                            "AND F_INSTRUCT_TYPE = '阀门控制' " +
                            "AND F_INPUTTOR != '系统必需'",tableName,meterNumber);
                }
            } else {
                sqlServer.run("UPDATE {} SET f_instruct_state='忽略冗余' " +
                                "WHERE F_INSTRUCT_STATE = '待发送' " +
                                "AND F_METERNUMBER = '{}' " +
                                "AND F_INSTRUCT_TYPE = '{}' " +
                                "AND (F_INSTRUCT_TITLE IS NULL OR F_INSTRUCT_TITLE = '{}') ",
                        tableName,meterNumber,type.getValue(),title);
            }
        }
    }
}
