/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.plugin.AccessToken;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.StreamingOutput;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="materials")
@Singleton
@Component
@Transactional
public class WeiXinService {
    static Logger log = Logger.getLogger(WeiXinService.class);
    public static boolean hasCustomService;
    public static int THUMBNAIL_SIZE;
    public static String FILE_LOCATION;

    @POST
    @Path(value="upload/{type}")
    public String uploadFile(@PathParam(value="type") String type, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        try {
            String fileName = fileDetail.getFileName();
            fileName = new String(fileName.getBytes("iso-8859-1"), "UTF-8");
            int pos = fileName.lastIndexOf(46);
            String thumbNailFileName = fileName.substring(0, pos) + "_";
            thumbNailFileName = type.equals("voice") ? thumbNailFileName + ".mp3" : (type.equals("video") ? thumbNailFileName + ".jpg" : thumbNailFileName + fileName.substring(pos));
            String fullFileName = FILE_LOCATION + "/" + fileName;
            this.writeToFile(uploadedInputStream, fullFileName);
            uploadedInputStream.close();
            String mediaId = null;
            if (hasCustomService && (mediaId = this.uploadWcMedia(fullFileName, fileName, type)) == null) {
                return "{\"code\":500, \"msg\":\"\u4e0a\u4f20\u7d20\u6750\u5230\u5fae\u4fe1\u5931\u8d25\uff01\"}";
            }
            File file = new File(fullFileName);
            if (type.equals("video")) {
                this.createVideoThumbNail(FILE_LOCATION + "/" + thumbNailFileName, fullFileName);
            } else if (type.equals("image")) {
                this.createImageThumbNail(FILE_LOCATION + "/" + thumbNailFileName, file);
            }
            if (hasCustomService) {
                return "{\"code\": 200, \"msgType\": \"" + type + "\", \"mediaId\": \"" + mediaId + "\", \"fileName\": \"" + fileName + "\", \"thumbnail\": \"" + thumbNailFileName + "\"}";
            }
            return "{\"code\": 200, \"msgType\": \"" + type + "\", \"fileName\": \"" + fileName + "\", \"thumbnail\": \"" + thumbNailFileName + "\"}";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"code\":500}";
        }
    }

    @POST
    @Path(value="del/{mediaId}")
    public String delMediaById(@PathParam(value="mediaId") String mediaId) {
        try {
            if (hasCustomService) {
                DefaultHttpClient client = new DefaultHttpClient();
                String url = "https://api.weixin.qq.com/cgi-bin/material/del_material??access_token=" + AccessToken.getAccessToken();
                HttpPost post = new HttpPost(url);
                post.setEntity((HttpEntity)new StringEntity("{\"mediaId\":\"" + mediaId + "\"}"));
                HttpResponse response = client.execute((HttpUriRequest)post);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject js = new JSONObject(result);
                    if (js.has("errcode") && js.getInt("errcode") == 0) {
                        return "{\"code\":200}";
                    }
                    return "{\"code\":500}";
                }
                return "{\"code\":500}";
            }
            return "{\"code\":200}";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"code\":500}";
        }
    }

    private String uploadWcMedia(String fileName, String desc, String type) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        String url = "://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + AccessToken.getAccessToken() + "&type=" + type;
        url = type.equals("video") ? "http" + url : "https" + url;
        HttpPost post = new HttpPost(url);
        MultipartEntity entity = new MultipartEntity();
        File file = new File(fileName);
        entity.addPart("media", (ContentBody)new FileBody(file));
        if (type.equals("video")) {
            String uuid = UUID.randomUUID().toString();
            entity.addPart("description", (ContentBody)new StringBody("{\"title\": \"" + uuid + "\", \"introduction\": \"" + uuid + "\"}"));
        }
        post.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() == 200) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject js = new JSONObject(result);
            if (js.has("media_id")) {
                return js.getString("media_id");
            }
            return null;
        }
        return null;
    }

    private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws Exception {
        FileOutputStream out = new FileOutputStream(new File(uploadedFileLocation));
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = uploadedInputStream.read(bytes)) != -1) {
            ((OutputStream)out).write(bytes, 0, read);
        }
        out.flush();
        ((OutputStream)out).close();
    }

    private void createImageThumbNail(String thumbNailFileName, File file) throws Exception {
        BufferedImage originImg = ImageIO.read(file);
        int d = originImg.getWidth() > originImg.getHeight() ? originImg.getWidth() : originImg.getHeight();
        double scale = (double)THUMBNAIL_SIZE * 1.0 / (double)d;
        int w = (int)((double)originImg.getWidth() * scale);
        int h = (int)((double)originImg.getHeight() * scale);
        BufferedImage img = new BufferedImage(w, h, 1);
        img.createGraphics().drawImage(originImg.getScaledInstance(w, h, 4), 0, 0, null);
        ImageIO.write((RenderedImage)img, "jpg", new File(thumbNailFileName));
    }

    private void createVoiceThumbNail(String thumbNailFileName, String fileName) throws Exception {
        String path = "cmd.exe /c ffmpeg -i " + fileName + " " + thumbNailFileName;
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec(path);
        pr.waitFor();
    }

    private void createVideoThumbNail(String thumbNailFileName, String fileName) throws Exception {
        File file = new File(thumbNailFileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                log.debug((Object)("\u66ff\u6362" + thumbNailFileName + "\u6210\u529f\uff01"));
            } else {
                log.debug((Object)("\u5220\u9664" + thumbNailFileName + "\u5931\u8d25\uff01"));
            }
        }
        String path = "cmd.exe /c ffmpeg -i " + fileName + " -ss 00:00:00.000 -vframes 1 " + thumbNailFileName;
        System.out.println("8888888888888888888888");
        System.out.println(path);
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec(path);
        pr.waitFor();
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        System.out.println("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }

    @POST
    @Path(value="material/{type}/{offset}/{count}")
    public String getmaterial(@PathParam(value="type") String type, @PathParam(value="offset") int offset, @PathParam(value="count") String count) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" + AccessToken.getAccessToken();
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity("{\"type\":\"" + type + "\",\"offset\":" + offset + ", \"count\":" + count + "}"));
        HttpResponse res = client.execute((HttpUriRequest)post);
        if (res.getStatusLine().getStatusCode() == 200) {
            String result = new String(EntityUtils.toString((HttpEntity)res.getEntity()).getBytes("iso-8859-1"), "UTF-8");
            log.debug((Object)("\u83b7\u53d6\u7d20\u6750\u8fd4\u56de\u4fe1\u606f" + result));
            return result;
        }
        return "{\"code\":500}";
    }

    @GET
    @Path(value="image/material/{mediaId}")
    @Produces(value={"image/jpeg"})
    public StreamingOutput getFullImage(final @PathParam(value="mediaId") String mediaId) throws IOException {
        return new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException {
                InputStream is = this.fetchImage(mediaId);
                int nextByte = 0;
                while ((nextByte = is.read()) != -1) {
                    outputStream.write(nextByte);
                }
                outputStream.flush();
                outputStream.close();
                is.close();
            }

            private InputStream fetchImage(String mediaId2) throws IOException {
                log.debug((Object)("mediaId:" + mediaId2));
                String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + AccessToken.getAccessToken();
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setReadTimeout(20000);
                conn.setConnectTimeout(20000);
                conn.setUseCaches(false);
                conn.connect();
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(conn.getOutputStream(), "UTF-8"), true);
                pw.print("{\"media_id\":\"" + mediaId2 + "\"}");
                pw.flush();
                InputStream is = conn.getInputStream();
                return is;
            }
        };
    }

    static {
        THUMBNAIL_SIZE = 200;
        log.debug((Object)"start access token background thread.");
        InputStream is = null;
        try {
            is = WeiXinService.class.getClassLoader().getResourceAsStream("config.properties");
            Properties prop = new Properties();
            prop.load(is);
            AccessToken.url = prop.getProperty("aturl");
            hasCustomService = Boolean.parseBoolean(prop.getProperty("hasCustomService"));
            THUMBNAIL_SIZE = Integer.parseInt(prop.getProperty("thumbNailSize"));
            FILE_LOCATION = prop.getProperty("fileLocation");
            if (hasCustomService) {
                AccessToken.getAccessToken();
            }
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

