SELECT
	*
FROM
	(
		SELECT
			s.*
		FROM
			(
				SELECT
					*, row_number () OVER (
						partition BY a.telnum
						ORDER BY
							a.outltime DESC
					) AS group_idx
				FROM
					(
						SELECT
							re.telnum,
							re.id,
							re.outltime,
							re.inltime,
							re.starttime,
							re.endtime,
							cc. TIME findtime,
							re.f_flghuifang
						FROM
							(
								SELECT
									*
								FROM
									t_records
								WHERE
								{ outltime != $$ : $outltime > '{condition.time}' $,
								$1 = 1 $ }

							) re
						LEFT JOIN (
							SELECT
								*
							FROM
								t_ccevents
							WHERE
								enevttype = 'FINDINLINE'
						) cc ON cc.rid = re.id
					) a
			) s
		WHERE
			s.group_idx = 1
	) aa
WHERE
	starttime = ''
AND f_flghuifang IS NULL
AND { condition.phone }
ORDER BY
	outltime
