SELECT
    f_repairtype,
    COUNT ( 0 ) AS telcount,
    SUM ( aa ) AS wccount,
    SUM ( bb ) AS wwccount,
    CAST(CAST(SUM ( aa )*100/COUNT ( 0 ) as decimal(10,2)) as varchar(50)) +'%'
FROM
    (
        SELECT
            swo.f_repairtype,
            CASE

                WHEN f_result_status = '已完成' THEN
                    1 ELSE 0
                END AS aa,
            CASE

                WHEN f_result_status IS NULL THEN
                    1 ELSE 0
                END AS bb
        FROM
            t_serviceworkorder swo
                LEFT JOIN t_servicework sw ON swo.id= sw.serviceid
        WHERE
                swo.f_workorder_type= '报修单'  and {condition}
    ) tt
GROUP BY
    tt.f_repairtype
