SELECT
	nam,
	SUM (denglushichang) AS denglushichang,
	SUM (zhimangshichang) AS zhimangshichang,
	SUM (zhimangcishu) AS zhimangcishu,
	SUM (weijie) AS weijie,
	SUM (yijie) AS yijie,
	SUM (weibo) AS weibo,
	SUM (jietingshichang) AS jietingshichang,
	SUM (threesjieting) AS threesjieting,
	SUM (quanbujieting) AS quanbujieting,
	SUM (jieru) AS jieru,
	SUM (jiechu) AS jiechu,
	SUM (zixundan) AS zixundan,
	SUM (tousudan) AS tousudan,
	SUM (baoxiudan) AS baoxiudan
FROM
	(
		SELECT
			NAME AS nam,
			SUM (opspan) AS denglushichang,
			0 zhimangshichang,
			0 zhimangcishu,
			0 weijie,
			0 yijie,
			0 weibo,
			0 jietingshichang,
			0 threesjieting,
			0 quanbujieting,
			0 jieru,
			0 jiechu,
			0 zixundan,
			0 tousudan,
			0 baoxiudan
		FROM
			T_ATTENDANT_STATUS
		WHERE
			operation = '登入'
		AND opstart >= '{startDate}'
		AND opstart <= '{endDate}'
		GROUP BY
			NAME
		UNION ALL
			SELECT
				NAME AS nam,
				0 denglushichang,
				SUM (opspan) AS zhimangshichang,
				COUNT (*) AS zhimangcishu,
				0 weijie,
				0 yijie,
				0 weibo,
				0 jietingshichang,
				0 threesjieting,
				0 quanbujieting,
				0 jieru,
				0 jiechu,
				0 zixundan,
				0 tousudan,
				0 baoxiudan
			FROM
				T_ATTENDANT_STATUS
			WHERE
				operation = '置忙'
			AND opstart >= '{startDate}'
			AND opstart <= '{endDate}'
			GROUP BY
				NAME
			UNION ALL
				SELECT
					telname AS nam,
					0 denglushichang,
					0 zhimangshichang,
					0 zhimangcishu,
					COUNT (*) AS weijie,
					0 yijie,
					0 weibo,
					0 jietingshichang,
					0 threesjieting,
					0 quanbujieting,
					0 jieru,
					0 jiechu,
					0 zixundan,
					0 tousudan,
					0 baoxiudan
				FROM
					t_records
				WHERE
					len(starttime) = 0
				and 	teltype='呼入'
				AND INLTIME >= '{startDate}'
				AND INLTIME <= '{endDate}'
				GROUP BY
					telname
				UNION ALL
					SELECT
						telname AS nam,
						0 denglushichang,
						0 zhimangshichang,
						0 zhimangcishu,
						0 weijie,
						COUNT (*) AS yijie,
						0 weibo,
						0 jietingshichang,
						0 threesjieting,
						0 quanbujieting,
						0 jieru,
						0 jiechu,
						0 zixundan,
						0 tousudan,
						0 baoxiudan
					FROM
						t_records
					WHERE
						len(starttime) != 0
						and 	teltype='呼入'
					AND INLTIME >= '{startDate}'
					AND INLTIME <= '{endDate}'
					GROUP BY
						telname
					UNION ALL
						SELECT
							gonghao AS nam,
							0 denglushichang,
							0 zhimangshichang,
							0 zhimangcishu,
							0 weijie,
							0 yijie,
							COUNT (*) AS weibo,
							0 jietingshichang,
							0 threesjieting,
							0 quanbujieting,
							0 jieru,
							0 jiechu,
							0 zixundan,
							0 tousudan,
							0 baoxiudan
						FROM
							T_CALL_LOG
						WHERE
							islink = 'BZ_CALLOUT'
						AND comingtime >= '{startDate}'
						AND comingtime <= '{endDate}'
						GROUP BY
							gonghao
						UNION ALL
							SELECT
								telname AS nam,
								0 denglushichang,
								0 zhimangshichang,
								0 zhimangcishu,
								0 weijie,
								0 yijie,
								0 weibo,
								SUM (
									datediff(minute , starttime, endtime)
								) AS jietingshichang,
								0 threesjieting,
								0 quanbujieting,
								0 jieru,
								0 jiechu,
								0 zixundan,
								0 tousudan,
								0 baoxiudan
							FROM
								t_records
							WHERE
								len(starttime) != 0
								and 	teltype='呼入'
							AND len(endtime) != 0
							AND INLTIME >= '{startDate}'
							AND INLTIME <= '{endDate}'
							GROUP BY
								telname
							UNION ALL
								SELECT
									telname AS nam,
									0 denglushichang,
									0 zhimangshichang,
									0 zhimangcishu,
									0 weijie,
									0 yijie,
									0 weibo,
									0 jietingshichang,
									COUNT (*) AS threesjieting,
									0 quanbujieting,
									0 jieru,
									0 jiechu,
									0 zixundan,
									0 tousudan,
									0 baoxiudan
								FROM
									t_records
								WHERE
									len(starttime) != 0
								AND len(endtime) != 0
								and 	teltype='呼入'
								AND datediff(minute , starttime, endtime) < 15
								AND INLTIME >= '{startDate}'
								AND INLTIME <= '{endDate}'
								GROUP BY
									telname
								UNION ALL
									SELECT
										telname AS nam,
										0 denglushichang,
										0 zhimangshichang,
										0 zhimangcishu,
										0 weijie,
										0 yijie,
										0 weibo,
										0 jietingshichang,
										0 threesjieting,
										COUNT (*) AS quanbujieting,
										0 jieru,
										0 jiechu,
										0 zixundan,
										0 tousudan,
										0 baoxiudan
									FROM
										t_records
									WHERE
										len(starttime) != 0
									AND len(endtime) != 0
									and 	teltype='呼入'
									AND INLTIME >= '{startDate}'
									AND INLTIME <= '{endDate}'
									GROUP BY
										telname
									UNION ALL
										SELECT
											telname AS nam,
											0 denglushichang,
											0 zhimangshichang,
											0 zhimangcishu,
											0 weijie,
											0 yijie,
											0 weibo,
											0 jietingshichang,
											0 threesjieting,
											0 quanbujieting,
											COUNT (*) AS jieru,
											0 jiechu,
											0 zixundan,
											0 tousudan,
											0 baoxiudan
										FROM
											t_records
										WHERE
											len(associatedid) != 0
											and 	teltype='呼入'
										AND INLTIME >= '{startDate}'
										AND INLTIME <= '{endDate}'
										GROUP BY
											telname
										UNION ALL
											SELECT
												b.nam AS nam,
												0 denglushichang,
												0 zhimangshichang,
												0 zhimangcishu,
												0 weijie,
												0 yijie,
												0 weibo,
												0 jietingshichang,
												0 threesjieting,
												0 quanbujieting,
												0 jieru,
												COUNT (*) AS jiechu,
												0 zixundan,
												0 tousudan,
												0 baoxiudan
											FROM
												(
													SELECT
														telname AS nam,
														associatedid
													FROM
														t_records
													WHERE
														len(associatedid) != 0
														and 	teltype='呼入'
													AND INLTIME >= '{startDate}'
													AND INLTIME <= '{endDate}'
												) b,
												(
													SELECT
														telname AS nam,
														ID
													FROM
														t_records
													WHERE
														len(associatedid) != 0
														and 	teltype='呼入'
													AND INLTIME >= '{startDate}'
													AND INLTIME <= '{endDate}'
												) c
											WHERE
												b.associatedid = c.ID
											GROUP BY
												b.nam
											UNION ALL
												SELECT
													f_operator_name AS nam,
													0 denglushichang,
													0 zhimangshichang,
													0 zhimangcishu,
													0 weijie,
													0 yijie,
													0 weibo,
													0 jietingshichang,
													0 threesjieting,
													0 quanbujieting,
													0 jieru,
													0 jiechu,
													COUNT (*) zixundan,
													0 tousudan,
													0 baoxiudan
												FROM
													t_consult
												WHERE
													f_created_date >= '{startDate}'
												AND f_created_date <= '{endDate}'
												GROUP BY
													f_operator_name
												UNION ALL
													SELECT
														f_operator_name AS nam,
														0 denglushichang,
														0 zhimangshichang,
														0 zhimangcishu,
														0 weijie,
														0 yijie,
														0 weibo,
														0 jietingshichang,
														0 threesjieting,
														0 quanbujieting,
														0 jieru,
														0 jiechu,
														0 zixundan,
														COUNT (*) tousudan,
														0 baoxiudan
													FROM
														t_complaint
													WHERE
														f_created_date >= '{startDate}'
													AND f_created_date <= '{endDate}'
													GROUP BY
														f_operator_name
													UNION ALL
														SELECT
															f_attendant AS nam,
															0 denglushichang,
															0 zhimangshichang,
															0 zhimangcishu,
															0 weijie,
															0 yijie,
															0 weibo,
															0 jietingshichang,
															0 threesjieting,
															0 quanbujieting,
															0 jieru,
															0 jiechu,
															0 zixundan,
															0 tousudan,
															COUNT (*) baoxiudan
														FROM
															t_service
														WHERE
															f_created_date >= '{startDate}'
														AND f_created_date <= '{endDate}'
														GROUP BY
															f_attendant
	) ttt
WHERE
	{ operator != $$ : $ nam = '{operator}' $,
	operator == $$ : $ 1 = 1 $,
	$$ }
GROUP BY
	nam
ORDER BY
	nam