SELECT
    rcyear,
    rcmonth,
    SUM(laidian) AS laidian,
    SUM(rengong) AS rengong,
    SUM(laidian) - SUM(rengong) AS dhs,
    SUM(jiexian) AS jiexian,
    SUM(huchu) AS huchu,
    CAST(CAST(SUM(jiexian) AS NUMERIC) / NULLIF(SUM(rengong), 0) AS NUMERIC(5,3)) AS jiexianlv,
    SUM(husun) AS husun,
    CAST(CAST(SUM(husun) AS NUMERIC) / NULLIF(SUM(rengong), 0) AS NUMERIC(5,3)) AS husunlv
FROM
    (
        SELECT
            YEAR(outltime) AS rcyear,

            MONTH(outltime) AS rcmonth,

            CASE WHEN rc.teltype = '呼入' THEN 1 ELSE 0 END AS laidian,

            CASE
            WHEN rc.teltype = '呼入' O
            AND findtime IS NOT NULL
            THEN 1
            ELSE 0
            END AS rengong,

            CASE
            WHEN rc.teltype = '呼入'
            AND findtime IS NOT NULL
            THEN 1
            ELSE 0
            END AS jiexian,

            CASE
            WHEN rc.teltype = '呼出'
            THEN 1
            ELSE 0
            END AS huchu,

            CASE
            WHEN rc.teltype = '呼入'
            AND (starttime = '' OR starttime IS NULL)
            AND endtime IS NOT NULL
            AND endtime != ''
            THEN 1
            ELSE 0
            END AS husun
        FROM
            t_records rc
        WHERE {condition}
    ) t
GROUP BY rcyear, rcmonth
ORDER BY rcmonth
