select
        '{startDate}'+'-'+'{endDate}' as f_data1,
        { attendant != $$ : $CONCAT({attendant})$ , $$ } as f_data2,
        max(f_data3) as f_data3,
        max(f_data4) as f_data4,
        max(f_data5) as f_data5,
        max(f_data6) as f_data6,
        max(f_data7) as f_data7
from (
         SELECT
             0 AS f_data3,
             0 AS f_data4,
             MAX ( f_data5 ) AS f_data5,
             MAX ( f_data6 ) AS f_data6,
             MAX ( f_data7 ) AS f_data7
         FROM
             (
                 SELECT
                     CASE
                         f_workorder_type
                         WHEN '预约单' THEN
                             COUNT ( 0 ) ELSE 0
                         END AS f_data5,
                     CASE
                         f_workorder_type
                         WHEN '咨询单' THEN
                             COUNT ( 0 ) ELSE 0
                         END AS f_data6,
                     CASE
                         f_workorder_type
                         WHEN '投诉单' THEN
                             COUNT ( 0 ) ELSE 0
                         END AS f_data7
                 FROM
                     t_serviceworkorder
                 where
                    1 = 1
                    { startDate != $$ : $ and f_created_date >= '{startDate}'$,$$ }
                    { endDate != $$ : $ and f_created_date <= '{endDate}'$,$$ }
                    { attendant != $$ : $ and f_attendant in ({attendant })$,$$ }
                 GROUP BY
                     f_workorder_type
             ) a

         UNION

         SELECT
             MAX ( f_data3 ) AS f_data3,
             MAX ( f_data4 ) AS f_data4,
             0 AS f_data5,
             0 AS f_data6,
             0 AS f_data7
         FROM
             (
                 SELECT
                     CASE
                         teltype
                         WHEN '呼入' THEN
                             COUNT ( 0 ) ELSE 0
                         END AS f_data3,
                     CASE
                         teltype
                         WHEN '呼出' THEN
                             COUNT ( 0 ) ELSE 0
                         END AS f_data4
                 FROM
                     t_records
                 where
                    1 = 1
                    { startDate != $$ : $ and outltime >= '{startDate}'$,$$ }
                    { endDate != $$ : $ and outltime <= '{endDate}'$,$$ }
                    { attendant != $$ : $ and telname in ({attendant })$,$$ }

                 GROUP BY
                     teltype
             ) b
) c
