SELECT
    isnull(f_left_name1,'') as f_left_name1,
    isnull(f_left_name2,'') as f_left_name2,
    isnull(sum( num ),0) as f_data1
FROM
    (
        SELECT
            case when ts.f_type = '换表' then td.f_project else ts.f_type end AS f_left_name1,
            CASE
                WHEN ts.f_type = '换表' THEN
                    ( CASE WHEN f_project IN ( '换表类型', '换表原因' ) THEN  td.f_content ELSE '' END )
                WHEN ts.f_type = '气量核对' THEN
                    ( CASE WHEN f_project IN ( '机械显示', '液晶显示' ) THEN td.f_project ELSE '' END )
                WHEN ts.f_type = '改管维修' THEN
                    (
                        CASE
                            WHEN f_project IN ( '引入方式', '是否高空作业' ) THEN
                                    td.f_project + ':' + td.f_content
                            WHEN f_project = '补装管卡' THEN
                                td.f_project ELSE ''
                            END
                        )
                WHEN ts.f_type = '作业确认' THEN
                    (
                        CASE
                            WHEN f_project IN ( '是否试火', '各部件是否检漏', '气表计量是否观察', '气表左右方向安装是否正确' ) THEN
                                    td.f_project + ':' + td.f_content
                            WHEN f_project IN ( '漏气维修', '抢险维修', '其他维修' ) THEN
                                td.f_project ELSE ''
                            END
                        ) ELSE ''
                END AS f_left_name2,
            CASE
                WHEN td.f_content IS NOT NULL THEN
                    1 ELSE 0
                END AS num
        FROM
            t_servicework ts1 left join
            t_servicerepair ts on ts1.id = ts.serviceid
                LEFT JOIN t_details td ON td.f_service_id = ts.id
        WHERE
            ts.f_type in ('换表','气量核对','改管维修',' 作业确认')
            and td.f_content IS NOT NULL {condition }
    ) a
WHERE
    f_left_name2 IS NOT NULL
  AND f_left_name2 != ''
GROUP BY
    f_left_name1,
    f_left_name2

UNION

    SELECT
        '立管维修' AS f_left_name1,
        '立管维修' AS f_left_name2,
        isnull(count( 0 ),0) AS f_data1
    FROM
        t_servicework ts1 left join
        t_servicerepair ts on ts1.id = ts.serviceid
      LEFT JOIN t_details td ON td.f_service_id = ts.id
    WHERE
            td.f_project IN ( '事故类型', '更换配件', '故障位置', '处理结果' )
      AND td.f_content IS NOT NULL {condition }

UNION

    SELECT
        '散户安装' AS f_left_name1,
        '散户安装' AS f_left_name2,
        isnull(count( 0 ),0) AS f_data1
    FROM
        t_servicework ts1 left join
        t_servicerepair ts on ts1.id = ts.serviceid
      LEFT JOIN t_details td ON td.f_service_id = ts.id
    WHERE
            td.f_project IN ( '表具位置', '立管情况', '是否开口' )
      AND td.f_content IS NOT NULL {condition }