SELECT
	f_order_man,-- 维修员名字
	SUM ( f_repair_count ) as f_repair_count,--需要维修总数
	SUM ( f_repair_num ) as f_repair_num,--维修数
	SUM ( f_repair_count ) - SUM ( f_repair_num ) AS f_no_repair_num,--未维修总数
    isnull(cast(cast(SUM ( f_repair_date_count ) as FLOAT)/3600 as NUMERIC(8,2)),0) as f_repair_date_count,--维修总时长单位(h)
    case when SUM ( f_repair_count ) > 0 then (CAST (CAST ( SUM ( f_repair_num ) * 1.0 * 100 / SUM ( f_repair_count ) AS DECIMAL ( 10, 2 ) ) AS VARCHAR ( 50 ) ) + '%') else '0%' end AS f_repair_percentage --维修百分比
FROM
	(
		SELECT
			f_order_man,
			COUNT ( f_workorder_type ) AS f_repair_count,
			0 f_repair_num,
			0 f_repair_date_count 
		FROM
			t_service 
		WHERE
			f_workorder_type = '报修单' and f_order_man is not null and f_order_man not like '%测试%' and f_order_man != 'yyc' and  {condition.condition1 }
		GROUP BY
			f_order_man 
	UNION ALL
		SELECT
            ts.f_order_man,
			0 f_repair_count,
			COUNT ( CASE f_result_status WHEN '已完成' THEN 1 ELSE 0 END ) AS f_repair_num,
			SUM ( datediff( second, f_date_come, f_date_leave ) ) AS f_repair_date_count 
		FROM
			t_servicework ts left join t_serviceworkorder tswo on ts.serviceid = tswo.id
		WHERE
            ts.f_workorder_type = '报修单' and ts.f_order_man is not null and ts.f_order_man not like '%测试%' and ts.f_order_man != 'yyc'
		and  {condition.condition2 }
		GROUP BY
            ts.f_order_man
	) a
GROUP BY
	f_order_man