SELECT
    tu.f_data1,
    tu.f_data2,
    isnull( tf.f_failure, '' ) AS f_data3
FROM
    t_userfiles uf
        LEFT JOIN (
        SELECT
            tu.f_gasmodel_id,
            isnull( tg.f_meter_brand, '' ) AS f_data1,
            isnull( tg2.f_meter_style, '' ) + '--(' + CAST( COUNT( 0 ) AS VARCHAR )+ ')' AS f_data2
        FROM
            t_userfiles tu
                LEFT JOIN t_gasbrand tg ON tu.f_gasbrand_id = tg.id
                LEFT JOIN t_gasmodel tg2 ON tu.f_gasmodel_id = tg2.id
        WHERE
                tu.f_table_state = '正常' and tg.f_meter_brand is not null and tg2.f_meter_style is not null
        GROUP BY
            tg.f_meter_brand,
            tg2.f_meter_style,
            tu.f_gasmodel_id
    ) tu ON uf.f_gasmodel_id = tu.f_gasmodel_id
        LEFT JOIN t_service ts ON uf.f_userinfo_id = ts.f_userinfo_id
        LEFT JOIN t_failure tf ON ts.f_service_id = tf.f_service_id
WHERE
    {condition } and f_data1 is not null
GROUP BY
    f_data1,
    f_data2,
    tf.f_failure