SELECT
	name, -- 所属大区
	f_orgname, --所属公司
	f_userinfo_code, --客户编号
	f_user_name, --客户姓名
	f_contact_phone, --手机
	f_residential_area, --小区
	f_address, --地址
	f_order_man, --置换员
	f_date  --置换时间
FROM
	(
	SELECT
		ts.id,
		ts.f_orgname,-- 所属公司
		tu.f_userinfo_code , -- 客户编号
		tu.f_user_name , -- 客户姓名
		ts.f_contact_phone , -- 手机
		ua.f_residential_area , -- 小区
		ts.f_address , -- 地址
		sw.f_order_man , -- 置换员
		sw.f_date , -- 置换时间
		oz.parentid,
		ts.f_state
	FROM
		-- 置换工单
		t_substitution ts
		-- 工作活动
		LEFT JOIN t_servicework sw ON sw.serviceid= ts.id
		-- 客户地址
		LEFT JOIN t_user_address ua ON ua.id= ts.f_addressid
		-- 客户档案
		LEFT JOIN t_userinfo tu ON tu.f_userinfo_id= ts.f_userinfo_id
		-- 组织
		LEFT JOIN t_organization oz ON oz.id= ts.f_orgid
		-- 条件：ts.f_userinfo_id is not null  and ts.f_userinfo_id <> '' and sw.f_is_userfilesadd = 已上传 ===》已建档
	WHERE
		ts.f_userinfo_id IS NOT NULL
		AND ts.f_userinfo_id <> ''
		AND f_state IS NULL
		AND sw.f_is_userfilesadd = '已上传'
	) se
	LEFT JOIN t_organization oa ON se.parentid = oa.id
	WHERE { condition }
ORDER BY
	se.f_date DESC
