SELECT
       ti.f_userinfo_id,
       tu.f_meternumber,
       f_userinfo_code,
       f_user_name,
       f_user_phone,
       ti.f_rent_phone,
       tu.f_user_type,
       ta.f_address,
       tu.f_meter_classify,
       case
           when tu.f_meter_classify = '物联网表' then tu.f_balance_amount
           else ti.f_balance
           end as f_balance,
       tu.f_user_id,
       tu.f_card_id,
       ti.f_orgname,
       ti.f_depname,
       ti.f_orgid,
       ti.f_user_state,
       ta.f_street,
       ta.f_residential_area,
       ta.f_building,
       ta.f_unit,
       ta.f_building_suffix,
       ta.f_unit_suffix,
       ta.f_floor,
       ta.f_floor_suffix,
       ta.f_room,
       ta.f_room_suffix,
       ta.f_slice_area,
       ta.f_usegas_area,
       th.f_oughtfee,
       ta.f_enter_number
FROM t_user_address ta
         LEFT JOIN (select * from t_userfiles where f_table_state = '正常') tu ON ta.id = tu.f_useraddress_id
         LEFT JOIN t_userinfo ti ON ta.f_userinfo_id = ti.f_userinfo_id
         left join (select tf.f_userinfo_id, count(0) phonenums from t_userinfo tf left join t_user_phone up on tf.f_userinfo_id = up.f_userinfo_id where up.f_rent_phone = '{phone}' group by tf.f_userinfo_id) tp on tp.f_userinfo_id = ti.f_userinfo_id
         left join (SELECT f_userinfo_id, SUM(f_oughtfee) f_oughtfee FROM t_handplan WHERE f_whether_pay = '否' AND f_hand_state = '有效' AND f_meter_state = '已抄表' GROUP BY f_userinfo_id) th on th.f_userinfo_id = ti.f_userinfo_id
WHERE
    { condition }
ORDER BY
    ti.f_userinfo_id
