select t2.f_order_man                 as f_repair_man,
       t1.f_material_name,
       t1.f_typenumber                as f_material_type,
       sum(t1.f_material_number)      as f_count,
       sum(cast(t1.f_fee as DECIMAL)) as f_money
from t_material_service t1
         left join t_serviceworkorder t2 on t1.f_process_id = t2.f_processid
where f_order_man is not null and {condition}
GROUP BY t1.f_material_name, t1.f_typenumber, t2.f_order_man
union all
select '合计'       as f_repair_man,
       null         as f_material_name,
       null         as f_material_type,
       sum(f_count) as f_count,
       sum(f_money) as f_money
from (select t2.f_order_man                 as f_repair_man,
             t1.f_material_name,
             t1.f_typenumber                as f_material_type,
             sum(t1.f_material_number)      as f_count,
             sum(cast(t1.f_fee as DECIMAL)) as f_money
      from t_material_service t1
               left join t_serviceworkorder t2 on t1.f_process_id = t2.f_processid
      where f_order_man is not null and {condition}
      GROUP BY t1.f_material_name, t1.f_typenumber, t2.f_order_man) t