select
      case when f_workorder_type ='咨询单' then '热线中心' else f_outlets end f_outlets_new,
      case when f_workorder_type ='咨询单' then f_attendant else f_order_man end f_order_man_new,
      case when f_workorder_type ='咨询单' then f_created_date else f_order_date end f_order_date_new,
      case when f_workorder_type ='咨询单' then f_created_date else f_date end f_date_new,
      case when f_workorder_type ='咨询单' then f_created_date else f_date_come end f_date_come_new,
      case when f_workorder_type ='咨询单' then f_created_date else f_date_leave end f_date_leave_new,
      case when f_workorder_type ='咨询单' then f_created_date else f_finish_time_show end f_finish_time_show_new,
      case when f_workorder_type ='咨询单' then '未逾期' else f_overdue_show end f_overdue_show_new,
      *
from (
         SELECT
             tswo.*,
             tsw.f_date,
             tsw.f_name,
             tsw.f_date_come,
             tsw.f_date_leave,
             tsw.f_signname,
             tsw.f_sign_imgid,
             case when tswo.f_workorder_type in ('咨询单','投诉单') then '已完成' else tsw.f_result_status end as f_result_status,
             tc.f_content as f_content2,
             tsw.f_service_idea,
             tsw.f_remarks as f_repair_remarks,--维修结果
             sa.defname,
             sa.sender,
             tswo.f_user_name +  '   ' +  tswo.f_address  as f_customer_info_show,
             case
                 when tswo.f_state is not null and tswo.f_state != '' then tswo.f_state
                 when sa.defname is not null and sa.defname != '' then sa.defname
                 else '完成'
                 end as f_state_show,
             case
                 when tswo.f_workorder_type != '报修单' then ''
                 when tsw.f_result_status = '已完成' then (
                     case
                         when
                                 tswo.f_finish_date is null or
                                 tswo.f_finish_date = '' or
                                 tsw.f_date is null or
                                 tsw.f_date = '' or
                                 tsw.f_date = '1900-01-01 00:00:00' or
                                 tsw.f_date < tswo.f_finish_date then '未逾期'
                         else '已逾期'
                         end
                     )
                 else (
                     case
                         when CONVERT(varchar(100), GETDATE(), 20) > tswo.f_finish_date then '已逾期'
                         else '未逾期'
                         end
                     )
                 end as f_overdue_show,
             CASE
                 WHEN tswo.f_workorder_type != '报修单' THEN -1
                 WHEN tswo.f_finish_date is null or  tswo.f_finish_date = '' or  tswo.f_finish_date = '1900-01-01 00:00:00'  then -1
                 WHEN tsw.f_result_status = '已完成' THEN DATEDIFF( SECOND, tswo.f_finish_date, tsw.f_date )
                 WHEN DATEDIFF( SECOND, tswo.f_finish_date, GETDATE( ) ) < 0 THEN -1
                 ELSE DATEDIFF( SECOND, tswo.f_finish_date, GETDATE( ) )
                 END overday,
             case
                 when f_finish_date = '1900-01-01 00:00:00' then ''
                 else f_finish_date
                 end as f_finish_time_show,
             tfm.f_content
         FROM
             t_serviceworkorder tswo
                 LEFT JOIN ( SELECT f_date,f_name,f_date_come,f_date_leave,f_signname,f_sign_imgid,f_service_idea,f_remarks,f_result_status,serviceid FROM t_servicework sw WHERE sw.id = ( SELECT MAX ( id ) FROM t_servicework WHERE serviceid = sw.serviceid ) ) tsw ON tswo.id= tsw.serviceid
                 LEFT JOIN ( SELECT * FROM ACTIVITYINS act
                             WHERE defname in ('话务员派单','站点接单', '维修员接单', '班组长派单', '维修完成','置换完成','安装完成','安装员接单','置换员接单','处理完成','预约安检') and state='开始活动'
             ) SA ON tswo.F_PROCESSID = sa.PROCESSID
                 LEFT JOIN ( SELECT serviceid,f_content FROM t_telinformation tin WHERE tin.id = ( SELECT MAX ( id ) FROM t_telinformation WHERE serviceid = tin.serviceid ) ) tfm ON tswo.id= tfm.serviceid
                left join t_consult tc on tswo.f_service_id = tc.f_service_id
         WHERE {condition}
) a
ORDER BY f_created_date desc
