--starttime 按话务员统计,这个时候已经接入,不能按大屏的外线接入时间算
SELECT
    RANK() OVER (ORDER BY s0.num DESC) AS id,
    s0.telname,  --话务员
    s5.id telid,     --工号
    cast(isnull(s0.num,0) as int)  connections,  --接线数
    cast(cast(isnull(s0.num,0) as float)/z0.num*100 as NUMERIC(6,2))  scale,  --接线率
    isnull(cast(cast(s4.num as FLOAT)/3600 as NUMERIC(8,2)),0)  onlinetime, --在线时长
    isnull(cast(cast(s6.num as FLOAT)/3600 as NUMERIC(8,2)),0)  callInTime, --呼入时长
    isnull(cast(cast(s7.num as FLOAT)/3600 as NUMERIC(8,2)),0)  callOutTime, --呼出时长
    isnull(cast(cast(s8.num as FLOAT)/3600 as NUMERIC(8,2)),0)  callBusyTime, --置忙时长
    isnull(cast(cast(s9.num as FLOAT)/3600 as NUMERIC(8,2)),0)  callNotBusyTime, --置闲时长
    isnull(s1.num,0)  degreenum,  --满意数
    isnull(s2.num,0)  nodegreenum,  --不满意数
    isnull(s3.num,0)  complaint,  --投诉数
    RANK() OVER (ORDER BY s0.num DESC) AS ranking,   --排名
    z0.num totalnum    --总接线
FROM
-- 接线数
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !=''
and starttime>='{startdate}' and starttime<='{enddate}' and teltype = '呼入'
GROUP BY telname
)s0 LEFT JOIN
-- 满意度 1
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !='' and degree=1
and starttime>='{startdate}' and starttime<='{enddate}'
GROUP BY telname
)s1  on s0.telname=s1.telname  LEFT JOIN
-- 满意度 3
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !='' and degree=3
and starttime>='{startdate}' and starttime<='{enddate}'
GROUP BY telname
)s2  on s0.telname=s2.telname  LEFT JOIN
-- 投诉数
(
SELECT  f_operator_name,count(*) num from t_complaint  where
 f_created_date>='{startdate}' and f_created_date<='{enddate}'
GROUP BY f_operator_name
)s3 on s0.telname=s3.f_operator_name LEFT JOIN
-- 在线时长
(
SELECT name,sum(opspan) num from t_attendant_status  where
 opstart>='{startdate}' and opstart<='{enddate}' and (operation ='置忙' or operation='登出')
GROUP BY name
)s4 on s0.telname=s4.name left join
--呼入时长
(
SELECT telname,SUM ( datediff( second, starttime, endtime ) ) num from t_records where endtime is not null and endtime !=''
and starttime>='{startdate}' and starttime<='{enddate}' and teltype = '呼入'
GROUP BY telname
)s6  on s0.telname=s6.telname LEFT JOIN
--呼出时长
(
SELECT telname,SUM ( datediff( second, starttime, endtime ) ) num from t_records where endtime is not null and endtime !=''
and starttime>='{startdate}' and starttime<='{enddate}' and teltype = '呼出'
GROUP BY telname
)s7  on s0.telname=s7.telname LEFT JOIN
--置忙时长
(
SELECT name,sum(opspan) num from t_attendant_status  where
opstart>='{startdate}' and opstart<='{enddate}' and operation ='置忙'
GROUP BY name
)s8 on s0.telname=s8.name left join
--置闲时长
(
SELECT name,sum(opspan) num from t_attendant_status  where
opstart>='{startdate}' and opstart<='{enddate}' and operation ='置闲'
GROUP BY name
)s9 on s0.telname=s9.name left join
-- 工号
(
SELECT  id,name from t_user
)s5 on s0.telname=s5.name,
-- 总接线数
(
SELECT count(*) num from t_records where starttime is not null and starttime !=''
and starttime>='{startdate}' and starttime<='{enddate}' and teltype = '呼入'
)z0
ORDER BY connections desc
