SELECT
    s0.HANDUPTIME,
    isnull( s1.huchu, 0 ) huchu,
    isnull( s0.huru, 0 ) huru
FROM
    (
        SELECT
            count(*) huru,
            substring( outltime, 0, 5 ) HANDUPTIME
        FROM
            t_records
        WHERE
              outltime >= '{startdate}'
          AND outltime <= '{enddate}'
          AND teltype = '呼入'
        GROUP BY
            substring( outltime, 0, 5 )
    ) s0,
    (
        SELECT
            count(*) huchu
        FROM
            t_records
        WHERE
              outltime >= '{startdate}'
          AND outltime <= '{enddate}'
          AND teltype = '呼出'
        GROUP BY
            substring( outltime, 0, 5 )
    ) s1
ORDER BY
    s0.HANDUPTIME DESC
