// outtime 只要来电话就有值
{entity.findDialect() == $SqlServer$: $SET datefirst 1$, $$}
SELECT
    SUM( phoneWeek ) AS phoneWeek,   --周累计呼入
    SUM ( inileWeek ) AS inileWeek,  -- 周累计接入
    SUM ( phoneYear ) AS phoneYear,  -- 年累计呼入
    SUM ( inileYear ) AS inileYear,  -- 年累计接入
    SUM ( phoneTotal ) AS phoneTotal, -- 呼入总数
    SUM ( quickTotal ) AS quickTotal,  -- 总数 前台计算   (quicktotal/iniletotal)*100  内线响铃时间-接听时间 / 内线接入数
    SUM ( iniletotal ) AS iniletotal -- 接入总数
FROM
	(
	SELECT COUNT
		( OUTLTIME ) AS phoneWeek,
		0 inileWeek,
		0 phoneYear,
		0 inileYear,
		0 phoneTotal,
		0 quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
		{entity.findDialect() == $SqlServer$: $OUTLTIME>=CONVERT(datetime,CONVERT(VARCHAR(10),(DateAdd(dd,1-datepart(weekday,getdate()),getdate()))))$, $to_date(OUTLTIME,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate+(1- to_char(sysdate,'D')))$}
      AND teltype = '呼入'
	UNION ALL
	SELECT
		0 phoneWeek,
		COUNT ( OUTLTIME ) AS inileWeek,
		0 phoneYear,
		0 inileYear,
		0 phoneTotal,
		0 quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
	  {entity.findDialect() == $SqlServer$: $ starttime >= CONVERT(datetime, CONVERT(VARCHAR(10), (DateAdd(dd, 1-datepart(weekday, getdate()), getdate()))))$, $ to_date(starttime,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate+(1- to_char(sysdate,'D')))$}
      AND teltype = '呼入'
	UNION ALL
	SELECT
		0 phoneWeek,
		0 inileWeek,
		COUNT (OUTLTIME) AS phoneYear,
		0 inileYear,
		0 phoneTotal,
		0 quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
		{entity.findDialect() == $SqlServer$: $OUTLTIME>=CONVERT(datetime, CONVERT(VARCHAR(4),getdate(),120))$, $to_date(OUTLTIME,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate,'yyyy')$}
      AND teltype = '呼入'
	UNION ALL
	SELECT
		0 phoneWeek,
		0 inileWeek,
		0 phoneYear,
		COUNT (OUTLTIME) AS inileYear,
		0 phoneTotal,
		0 quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
	  {entity.findDialect() == $SqlServer$: $ starttime>=CONVERT(datetime, CONVERT(VARCHAR(4), getdate(), 120))$,$ to_date(starttime,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate,'yyyy')$}
      AND teltype = '呼入'
    UNION ALL
	SELECT
		0 phoneWeek,
		0 inileWeek,
		0 phoneYear,
		0 inileYear,
		COUNT ( OUTLTIME ) AS phoneTotal,
		0 quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
		{entity.findDialect() == $SqlServer$: $OUTLTIME>=CONVERT(datetime, CONVERT(VARCHAR(10), getdate(), 120))$, $to_date(OUTLTIME,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate)$}
      AND teltype = '呼入'
    UNION ALL
    SELECT
		0 phoneWeek,
		0 inileWeek,
		0 phoneYear,
		0 inileYear,
		0 phoneTotal,
		COUNT ( OUTLTIME ) AS quickTotal,
		0 iniletotal
	FROM
		t_records
	WHERE
	  {entity.findDialect() == $SqlServer$: $Len(STARTTIME)>0 AND Len(INLTIME)>0 AND datediff(ss,CONVERT(datetime, INLTIME, 20), CONVERT(datetime, STARTTIME, 20))<5 AND OUTLTIME>=CONVERT(datetime, CONVERT(VARCHAR(10), getdate(), 120))$,$length(STARTTIME)>0 and length(INLTIME)>0 and nvl(TO_NUMBER((TO_DATE(STARTTIME,'yyyy-mm-dd hh24:mi:ss')- TO_DATE(INLTIME,'yyyy-mm-dd hh24:mi:ss'))*24*60*60),0)<5 and to_date(OUTLTIME,'yyyy-MM-dd HH24:mi:ss')>=TRUNC(SYSDATE)$}
      AND teltype = '呼入'
		 UNION ALL
	SELECT
		0 phoneWeek,
		0 inileWeek,
		0 phoneYear,
		0 inileYear,
		0 phoneTotal,
		0 quickTotal,
		COUNT ( OUTLTIME ) AS iniletotal
	FROM
		t_records
	WHERE
        {entity.findDialect() == $SqlServer$: $STARTTIME>=CONVERT(datetime, CONVERT(VARCHAR(10), getdate(), 120))$, $to_date(STARTTIME,'yyyy-MM-dd HH24:mi:ss')>=trunc(sysdate)$}
      AND teltype = '呼入'
) t
