SELECT
	tswo.*,
    tf.f_failure,
    tf.f_failure_name,
    tf.f_failure_name + tf.f_failure as f_failure_,
	tsw.f_date,
	tsw.f_name,
	tsw.f_date_come,
	tsw.f_date_leave,
	tsw.f_signname,
	tsw.f_sign_imgid,
	tsw.f_result_status,
	tsw.f_service_idea,
    tsw.f_remarks as f_repair_remarks,--维修结果
    td.f_content, -- 隐患信息的隐患备注
	sa.defname,
	sa.sender,
	concat(tswo.f_userinfo_code , '   ',tswo.f_user_name , '   ', tswo.f_address) as f_customer_info_show,
	case
	    when tswo.f_state is not null and tswo.f_state != '' then tswo.f_state
        when sa.defname is not null and sa.defname != '' then sa.defname
        else '完成'
	end as f_state_show,
    case
        when tswo.f_workorder_type != '报修单' then ''
        when tsw.f_result_status = '已完成' then (
            case
                when
                    tswo.f_finish_date is null or
                    tswo.f_finish_date = '' or
                    tsw.f_date is null or
                    tsw.f_date = '' or
                    tsw.f_date = '1900-01-01 00:00:00' or
                    tsw.f_date < tswo.f_finish_date then '未逾期'
                else '已逾期'
            end
        )
        else (
            case
                when CONVERT(varchar(100), GETDATE(), 20) > tswo.f_finish_date then '已逾期'
                else '未逾期'
            end
        )
    end as f_overdue_show,
    case
        when f_finish_date = '1900-01-01 00:00:00' then ''
        else f_finish_date
    end as f_finish_time_show
FROM
	t_serviceworkorder tswo
	left join t_failure tf on tswo.f_service_id = tf.f_service_id
	LEFT JOIN ( SELECT * FROM t_servicework sw WHERE sw.id = ( SELECT MAX ( id ) FROM t_servicework WHERE serviceid = sw.serviceid ) ) tsw ON tswo.id= tsw.serviceid
	LEFT JOIN ( SELECT * FROM ACTIVITYINS act
                     WHERE defname in ('话务员派单','站点接单', '维修员接单', '班组长派单', '维修完成','置换完成','安装完成','安装员接单','置换员接单','处理完成','结案') and state='开始活动'
             ) SA ON tswo.F_PROCESSID = sa.PROCESSID
    left join (select * from t_servicerepair where  f_type = '隐患信息'  ) tsp on tsp.serviceid = tsw.id
    left join (select * from t_details where  f_project = '隐患备注') td on td.f_service_id = tsp.id
WHERE {condition}
ORDER BY f_created_date desc