SELECT
    MAX(torg.name) as name,
    SUM ( zixundan ) AS zixundan,--咨询单
    SUM ( tousudan ) AS tousudan,--投诉单
    SUM ( baoxiudan ) AS baoxiudan,--报修单
    SUM ( qiangxiu ) AS qiangxius,--抢修
    SUM ( fuwu ) AS fuwus,--服务
    SUM ( zhenggai ) AS zhenggais,--整改
    SUM ( zhihuantongqi ) AS zhihuantongqis,--置换通气
    SUM(zxzxdan) AS zxzxdan, --在线咨询
    SUM(wtzxdan) AS wtzxdan, --问题咨询
    SUM(gst) AS gst, --改三通
    SUM(gbgg) AS gbgg, --改管改表
    SUM(ggrg) AS ggrg,--更改软管
    SUM(azzjbglrsq) AS azzjbglrsq,--安装灶具/壁挂炉/热水器
    SUM(azbjq) AS azbjq,--安装报警器
    SUM(tqyy) AS tqyy, --通气预约
    SUM(aj) AS aj, --安检
    SUM(qt) AS qt --其他

FROM
    (
        SELECT
            f_orgid as orgid,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jieru,
            0 jiechu,
            COUNT ( * ) zixundan,
            CASE
                WHEN MIN(f_handlingtype) = '下派' THEN
                    1 ELSE 0
                END AS wtzxdan,
            CASE
                WHEN MIN(f_handlingtype) = '处理' THEN
                    1 ELSE 0
                END AS zxzxdan,
            0 tousudan,
            0 baoxiudan,
            0 gst,
            0 gbgg,
            0 ggrg,
            0 azzjbglrsq,
            0 azbjq,
            0 tqyy,
            0 aj,
            0 qt,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_consult
        WHERE
                f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
          AND f_orgid IN { f_filiale_id }
        GROUP BY
            f_orgid UNION ALL

        SELECT
            f_orgid as orgid,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 zxzxdan,
            0 wtzxdan,
            COUNT ( * ) tousudan,
            0 baoxiudan,
            0 gst,
            0 gbgg,
            0 ggrg,
            0 azzjbglrsq,
            0 azbjq,
            0 tqyy,
            0 aj,
            0 qt,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_complaint
        WHERE
            f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
          AND f_orgid	IN { f_filiale_id }
        GROUP BY
            f_orgid UNION ALL

        SELECT
            f_filiale_id as orgid,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 zxzxdan,
            0 wtzxdan,
            0 tousudan,
            COUNT ( * ) baoxiudan,
            SUM ( CASE WHEN f_repairtype like '%改三通%' THEN 1 ELSE 0 END ) gst,
            SUM ( CASE WHEN f_repairtype like '%改表/管道%' THEN 1 ELSE 0 END ) gbgg,
            SUM ( CASE WHEN f_repairtype like '%更换软管%' THEN 1 ELSE 0 END ) ggrg,
            SUM ( CASE WHEN f_repairtype like '%安装灶具/壁挂炉/热水器%' THEN 1 ELSE 0 END ) azzjbglrsq,
            SUM ( CASE WHEN f_repairtype like '%安装报警器%' THEN 1 ELSE 0 END ) azbjq,
            SUM ( CASE WHEN f_repairtype like '%通气预约%' THEN 1 ELSE 0 END ) tqyy,
            SUM ( CASE WHEN f_repairtype like '%安检%' THEN 1 ELSE 0 END ) aj,
            SUM ( CASE WHEN f_repairtype IS NULL THEN 1 ELSE 0 END ) qt,
            SUM ( CASE WHEN f_repairtype like '%抢修%' THEN 1 ELSE 0 END ) qiangxiu,
            SUM ( CASE WHEN f_repairtype like '%服务%' THEN 1 ELSE 0 END ) fuwu,
            SUM ( CASE WHEN f_repairtype like '%整改%' THEN 1 ELSE 0 END ) zhenggai,
            SUM ( CASE WHEN f_repairtype like '%置换通气%' THEN 1 ELSE 0 END ) zhihuantongqi
        FROM
            t_serviceworkorder
        WHERE
            f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
          AND f_filiale_id IN { f_filiale_id }
        GROUP BY
            f_filiale_id
    ) ttt
        LEFT JOIN t_organization torg ON ttt.orgid = torg.id
WHERE
    { condition }
  AND 1 = 1
  AND orgid IS NOT NULL
  AND orgid != ''
GROUP BY
    orgid
ORDER BY
    orgid