SELECT
	u.name,
	quanbujieting,-- 全部接听数
	weijie,-- 未接数
	yijie,-- 已接数
	CONVERT ( FLOAT, round( jietingshichang, 2 ) ) AS jietingshichang,-- 接听时长
	CONVERT ( FLOAT, round( pingjun, 2 ) ) AS pingjun,-- 平均
	CONVERT ( FLOAT, round( yijie / ( quanbujieting * 1.0 ), 2 ) ) AS jietinglv,-- 接听率
	waibo,-- 外拨
	CONVERT ( FLOAT, round( waiboshichang, 2 ) ) AS waiboshichang,--外拨时长
	CONVERT ( FLOAT, round( waiboshichang / ( waibo * 1.0 ), 2 ) ) AS pingjunwaibo,-- 平均外拨

	isnull( CAST ( CAST ( s8.num AS FLOAT ) / 3600 AS NUMERIC ( 8, 2 ) ), 0 ) callBusyTime,--置忙时长
	isnull( CAST ( CAST ( s9.num AS FLOAT ) / 3600 AS NUMERIC ( 8, 2 ) ), 0 ) callNotBusyTime,--置闲时长
	zixundan,-- 咨询单数
	tousudan,-- 投诉单数
	baoxiudan,-- 报修单数
	dianhuodan -- 点火单数
FROM
	t_user u --全部接听
		LEFT JOIN (
		SELECT
			telname AS name,
			COUNT ( * ) AS quanbujieting
		FROM
			t_records
		WHERE
				teltype = '呼入'
		  AND { startDate != $$ : $inltime > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $inltime <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) q ON q.name= u.name -- 未接
		LEFT JOIN (
		SELECT
			telname AS name,
			COUNT ( * ) AS weijie
		FROM
			t_records
		WHERE
				len( starttime ) = 0
		  AND teltype = '呼入'
		  AND { startDate != $$ : $inltime > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $inltime <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) w ON w.name= u.name -- 已接
		LEFT JOIN (
		SELECT
			telname AS name,
			COUNT ( * ) AS yijie
		FROM
			t_records
		WHERE
			len( starttime ) != 0
		AND teltype = '呼入'
		AND { startDate != $$ : $inltime > '{startDate}' $,
		startDate == $$ : $1 = 1 $,$$ }
		AND { endDate != $$ : $inltime <= '{endDate}' $,
		endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) y ON y.name= u.name --接听时长（分）
		LEFT JOIN (
		SELECT
			telname AS name,
			SUM ( datediff( s, starttime, endtime ) ) / 60.00 AS jietingshichang
		FROM
			t_records
		WHERE
			len( starttime ) != 0
		AND teltype = '呼入'
		AND len( endtime ) != 0
		AND { startDate != $$ : $starttime > '{startDate}' $,
		startDate == $$ : $1 = 1 $,$$ }
		AND { endDate != $$ : $starttime <= '{endDate}' $,
		endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) t ON t.name= u.name --呼入平均时长(分)
		LEFT JOIN (
		SELECT
			telname AS name,
			SUM ( datediff( s, starttime, endtime ) ) / ( COUNT ( * ) * 60.0 ) AS pingjun
		FROM
			t_records
		WHERE
			LEN( starttime ) != 0
		AND teltype = '呼入'
		AND len( endtime ) != 0
		AND { startDate != $$ : $starttime > '{startDate}' $,
		startDate == $$ : $1 = 1 $,$$ }
		AND { endDate != $$ : $starttime <= '{endDate}' $,
		endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) z ON z.name= u.name --外拨数量
		LEFT JOIN (
		SELECT
			telname AS name,
			COUNT ( * ) AS waibo
		FROM
			t_records
		WHERE
				teltype = '呼出'
		  AND { startDate != $$ : $starttime > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $starttime <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) f ON f.name= u.name --外拨时长(分)
		LEFT JOIN (
		SELECT
			telname AS name,
			SUM ( datediff( s, starttime, endtime ) ) / 60.00 AS waiboshichang
		FROM
			t_records
		WHERE
				teltype = '呼出'
		  AND len( starttime ) != 0
		AND len( endtime ) != 0
		AND { startDate != $$ : $starttime > '{startDate}' $,
		startDate == $$ : $1 = 1 $,$$ }
		AND { endDate != $$ : $starttime <= '{endDate}' $,
		endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			telname
	) x ON x.name= u.name --置忙时长
		LEFT JOIN (
		SELECT
			name,
			SUM ( opspan ) num
		FROM
			t_attendant_status
		WHERE
			{ startDate != $$ : $opstart >= '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $opstart <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		  AND operation = '置忙'
		GROUP BY
			name
	) s8 ON q.name= s8.name --置闲时长
		LEFT JOIN (
		SELECT
			name,
			SUM ( opspan ) num
		FROM
			t_attendant_status
		WHERE
			{ startDate != $$ : $opstart >= '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $opstart <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		  AND operation = '置闲'
		GROUP BY
			name
	) s9 ON q.name= s9.name --咨询单
		LEFT JOIN (
		SELECT
			f_operator_name AS name,
			COUNT ( * ) AS zixundan
		FROM
			t_consult
		WHERE
			{ startDate != $$ : $f_created_date > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $f_created_date <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			f_operator_name
	) c ON c.name= u.name --投诉单
		LEFT JOIN (
		SELECT
			f_operator_name AS name,
			COUNT ( * ) AS tousudan
		FROM
			t_complaint
		WHERE
			{ startDate != $$ : $f_created_date > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $f_created_date <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		GROUP BY
			f_operator_name
	) b ON b.name= u.name --报修单
		LEFT JOIN (
		SELECT
			f_attendant AS name,
			COUNT ( * ) AS baoxiudan
		FROM
			t_service
		WHERE
			{ startDate != $$ : $f_created_date > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $f_created_date <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		  AND ( f_repairtype != '点火通气' )
		GROUP BY
			f_attendant
	) a ON a.name= u.name --点火通气单
		LEFT JOIN (
		SELECT
			f_attendant AS name,
			COUNT ( * ) AS dianhuodan
		FROM
			t_service
		WHERE
			{ startDate != $$ : $f_created_date > '{startDate}' $,
			startDate == $$ : $1 = 1 $,$$ }
		  AND { endDate != $$ : $f_created_date <= '{endDate}' $,
			endDate == $$ : $1 = 1 $,$$ }
		  AND ( f_repairtype = '点火通气' )
		GROUP BY
			f_attendant
	) d ON d.name= u.name
WHERE
		u.rolestr LIKE '%热线管理员%'
  AND u.state!= '离职'
	AND quanbujieting IS NOT NULL
