SELECT
	*,
    case when telcost > 0 then '是' else '否' END  isjietong
FROM
	(
		SELECT
            toc.total,
			re. ID ID,
			re.teltype teltype,
			re.telnum telnum,
			case when re.telname = '未设置工号'then '用户挂断' else re.telname end  telname,
			re. INLINE INLINE,
			re. OUTLINE OUTLINE,
			re.recordfile recordfile,
			re.outltime outltime,
			re.findtime findtime,
			re.inltime inltime,
			re.starttime starttime,
			re.endtime endtime,
			re.savetime savetime,
			re. DEGREE DEGREE,
            re.f_flghuifang,
            re.callid,
            re.f_filiale_id,
            CASE
                WHEN re.degree = '1' THEN
                    '非常满意'
                WHEN re.degree = '2' THEN
                    '满意'
                WHEN re.degree = '3' THEN
                    '一般'
                WHEN re.degree = '4' THEN
                    '不满意'
                WHEN re.degree = '5' THEN
                    '非常不满意' ELSE '非常满意'
                END degrees,   --非常满意  1 满意 2 一般 3 不满意4 非常不满意5

			{entity.findDialect()==$SqlServer$:$CASE
		WHEN len (cc. TIME) = 0
		OR cc. TIME IS NULL THEN
			0
		ELSE
			datediff (ss, re.outltime, cc. TIME)
		END findcost,
		CASE
	WHEN len (cc. TIME) = 0
	OR len (re.inltime) = 0
	OR cc. TIME IS NULL THEN
		0
	ELSE
		datediff (ss, cc. TIME, re.inltime)
	END ringcost,
	CASE
WHEN len (re.starttime) = 0
OR len (re.inltime) = 0 THEN
	0
ELSE
	datediff (ss, re.inltime, re.starttime)
END incost,
 CASE
WHEN len (re.starttime) = 0
OR len (re.endtime) = 0 THEN
	0
ELSE
	datediff (ss, re.starttime, re.endtime)
END telcost,
 CASE
WHEN len (re.savetime) = 0
OR len (re.endtime) = 0 THEN
	0
ELSE
	datediff (ss, re.endtime, re.savetime)
END savecost$,

			$
			CASE
WHEN cc. TIME IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				cc. TIME,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.outltime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END findcost,
 CASE
WHEN cc. TIME IS NULL
OR re.inltime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.inltime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				cc. TIME,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END ringcost,
 CASE
WHEN re.starttime IS NULL
OR re.inltime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.starttime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.inltime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END incost,
 CASE
WHEN re.starttime IS NULL
OR re.endtime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.endtime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.starttime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END telcost,
 CASE
WHEN re.savetime IS NULL
OR re.endtime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.savetime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.endtime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END savecost
			$}




FROM
	t_records re
        LEFT JOIN (
            SELECT *
            FROM (
                SELECT *,
                row_number ( ) OVER ( partition BY rid ORDER BY time DESC ) AS group_idx
                FROM t_ccevents
            WHERE
                enevttype = 'FINDINLINE'
            ) tt
            WHERE
            group_idx = 1
        ) cc ON cc.rid = re. ID
            left join (
            select
            telnum,
            count(*) as  total
            from t_records
            where { condValue }
            and  teltype='呼入'
            group   by  telnum
            )  toc   on toc.telnum=re.telnum
	) t_records
WHERE
	{ condition }
ORDER BY
    { orderitem }
