/*
 * Decompiled with CFR 0.152.
 */
package com.aote.timer;

import com.af.plugins.DateTools;
import com.aote.config.SystemConfig;
import com.aote.util.other.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Base64Util {
    private static final int CACHE_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveImage(String rootDir, String data, String filename) {
        File dir = new File(rootDir + File.separator + DateTools.getNow((String)"yyyy-MM-dd"));
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow((String)"yyyy_MM_dd_hh_mm_ss") + filename);
            fop = new FileOutputStream(file);
            byte[] content = Base64Utils.decodeBuffer((String)data.split(",")[1]);
            fop.write(content);
            fop.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64(String imgUrl) {
        if (!imgUrl.startsWith("http")) {
            imgUrl = SystemConfig.System.getProxyUrl() + imgUrl;
        }
        URL url = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        HttpURLConnection httpUrl = null;
        try {
            url = new URL(imgUrl);
            httpUrl = (HttpURLConnection)url.openConnection();
            httpUrl.connect();
            httpUrl.getInputStream();
            is = httpUrl.getInputStream();
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            String string = Base64.getEncoder().encodeToString(outStream.toByteArray());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpUrl != null) {
                httpUrl.disconnect();
            }
        }
        return imgUrl;
    }

    public static String encodeFile(String filePath) throws Exception {
        byte[] bytes = Base64Util.fileToByte(filePath);
        return Base64Util.encode(bytes);
    }

    public static byte[] fileToByte(String filePath) throws Exception {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                out.write(cache, 0, nRead);
                out.flush();
            }
            out.close();
            in.close();
            data = out.toByteArray();
        }
        return data;
    }

    public static String encode(byte[] bytes) {
        return new String(Base64Util.encodeBuffer(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] encodeBuffer(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encode(bytes);
    }
}

