/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="file_new")
@Component
@Transactional
public class FileServiceNew {
    static Logger log = Logger.getLogger(FileServiceNew.class);
    @Autowired
    private EntityServer entityServer;

    private String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        }
        catch (RuntimeException var5) {
            throw var5;
        }
        catch (Exception var6) {
            throw new RuntimeException(var6);
        }
    }

    public String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    @Path(value="/savefile_plus")
    @POST
    public String savefile(byte[] file, @QueryParam(value="filename") String filename, @QueryParam(value="module") String module, @QueryParam(value="userinfoId") String userinfoId, @QueryParam(value="fusetype") String fusetype) throws Exception {
        if (Objects.nonNull(fusetype)) {
            fusetype = fusetype.replace('_', '&');
        }
        log.error((Object)("\u8fdb\u5165\u6587\u4ef6\u4e0a\u4f20 \u540d\u79f0----" + filename));
        log.error((Object)("\u6587\u4ef6\u5927\u5c0f----" + file.length));
        if (file.length == 0) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e3a0");
        }
        String realpath = ModuleMapper.getAttr((String)module, (String)"upload");
        log.error((Object)("realpath1111----" + realpath));
        realpath = this.getRealPath(realpath) + File.separator + filename;
        log.error((Object)("realpath2221----" + realpath));
        File f = new File(realpath);
        DataOutputStream dOutputStream = new DataOutputStream(new FileOutputStream(f));
        dOutputStream.write(file);
        dOutputStream.close();
        log.debug((Object)("\u5199\u5b8c\u540e\u6587\u4ef6\u5927\u5c0f----" + f.length()));
        String filetype = filename.split("\\.")[1];
        JSONObject map = new JSONObject();
        map.put("f_filename", (Object)filename);
        String uploaddate = this.getFileUploadDate();
        map.put("f_uploaddate", (Object)uploaddate);
        map.put("f_blobid", (Object)userinfoId);
        map.put("fusetype", (Object)fusetype);
        map.put("f_filetype", (Object)filetype);
        map.put("f_realpath", (Object)realpath);
        map.put("f_downloadpath", (Object)realpath);
        JSONObject result = new JSONObject(this.entityServer.partialSave("t_files", map));
        return result.getString("id");
    }

    @Path(value="/savefile_form")
    @POST
    @Consumes(value={"multipart/form-data"})
    public String savefile(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="module") String module, @QueryParam(value="userinfoId") String userinfoId, @QueryParam(value="fusetype") String fusetype) throws Exception {
        if (Objects.nonNull(fusetype)) {
            fusetype = fusetype.replace('_', '&');
        }
        log.error((Object)("\u8fdb\u5165\u6587\u4ef6\u4e0a\u4f20savefile_plus1   \u540d\u79f0----" + fileDetail.getFileName()));
        log.error((Object)("\u6587\u4ef6\u5927\u5c0f----" + fileDetail.getSize()));
        if (fileDetail.getSize() == 0L) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e3a0");
        }
        String realpath = ModuleMapper.getAttr((String)module, (String)"upload");
        realpath = this.getRealPath(realpath) + File.separator + fileDetail.getFileName();
        File f = new File(realpath);
        Files.copy(uploadedInputStream, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        log.debug((Object)("\u5199\u5b8c\u540e\u6587\u4ef6\u5927\u5c0f----" + f.length()));
        String filetype = fileDetail.getFileName().split("\\.")[1];
        JSONObject map = new JSONObject();
        map.put("f_filename", (Object)fileDetail.getFileName());
        String uploaddate = this.getFileUploadDate();
        map.put("f_uploaddate", (Object)uploaddate);
        map.put("f_blobid", (Object)userinfoId);
        map.put("fusetype", (Object)fusetype);
        map.put("f_filetype", (Object)filetype);
        map.put("f_realpath", (Object)realpath);
        map.put("f_downloadpath", (Object)realpath);
        JSONObject result = new JSONObject(this.entityServer.partialSave("t_files", map));
        return result.getString("id");
    }
}

