package com.aote.timer;

import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author ZhangJunJie
 * @Date 2022-01-14
 * <p>
 * 概要：置换定时器建档
 */
public class SubsitutionTimer {
    private final static Logger log = Logger.getLogger(SubsitutionTimer.class);
    // 转发营收接口的nginx地址  如：127.0.0.1:8499
    private  String revenueurl;

    public void setRevenueurl(String revenueurl) {
        this.revenueurl = revenueurl;
    }

    public void setLogicService(LogicService logicService) {
        this.logicService = logicService;
    }

    @Autowired
    private LogicService logicService;

    public void  sendWorkTimer() {
        try {
            log.debug("开始执行置换系统定时器建档逻辑,转发到营收接口的nginx地址配置的为:"+revenueurl);
            if ("".equals(revenueurl)) {
                log.error("未设置置换系统转发到营收系统的nginx地址：设置地址如：127.0.0.1:8400 不加http:// 不加斜线");
                return;
            }
            logicService.xtSave("substitutionAddUser", "{data:{revenueurl:'"+revenueurl+"'}}");
            log.debug("执行置换系统定时器建档逻辑结束");
        } catch (Exception e) {
            log.error("置换系统定时器建档，执行错误，错误原因：\n",e);
            e.printStackTrace();
        }
    }
}
