package com.aote.timer;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.plugin.Public;
import com.aote.rs.LogicService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class HanZhongRecordsTimer {
    @Autowired
    private LogicService logic;

    public void toSaveCallRecords() throws Exception {
        System.out.println("开始执行toSaveCallRecords");
        //  获取当前时间
        String startDate = DateTools.getNow2();
        //  获取半个小时之后的时间
        LocalDateTime currentTime = LocalDateTime.parse(startDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime halfHourLater = currentTime.plusMinutes(-30);
        String endDate = halfHourLater.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        //  设置开始时间和结束时间
        JSONObject callListParams = new JSONObject();
        callListParams.put("StartDate", startDate);
        callListParams.put("EndDate", endDate);
        //  获取请求头
        String token = this.logic.xtSave("login", "{}");
        //  调用 logic->selectPhoneRecord 获取 获取电话记录的url
        String url = this.logic.xtSave("selectPhoneRecord", callListParams.toString()).replace(" ", "%20");
        //  使用 httpGet 请求调用 客户提供的接口获取电话记录
        String str = Public.httpGet(url, token);
        String recordsRes = JsonTools.convertToJson(str).get("result").toString();
        JSONArray records = JsonTools.convertToJson(recordsRes).getJSONArray("records");
        //  保存电话记录
        this.logic.xtSave("saveCallList", "{data: {records: " + records.toString() + "}}");
    }
}