package com.aote.timer;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.plugin.Public;
import com.aote.rs.LogicService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class HanZhongCallLoseTimer {
    @Autowired
    private LogicService logic;


    public void toSaveCallLoss() throws Exception{
        System.out.println("开始执行toSaveCallLoss");
        //  获取昨天时间
        String yesterdayTime = DateTools.getDelayDate(DateTools.getNow2(), "DATE", "-1");
        String yesterdayDate = yesterdayTime.split(" ")[0].replace("-", "");
        //  设置昨天日期
        JSONObject callLossParams = (new JSONObject()).put("date", yesterdayDate);
        //  获取呼损记录
        String lossListRes = this.logic.xtSave("getCallLossList", callLossParams.toString());
        JSONArray lossList = JsonTools.convertToJson(lossListRes).getJSONArray("result");
        //  保存呼损记录
        this.logic.xtSave("saveLossList", "{data: {lossList: " + lossList.toString() + "}}");
    }
}