package com.aote.rs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import com.aote.ThreadResource;
import javax.transaction.Transactional;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aote.util.ResourceHelper;
import com.aote.sql.SqlServer;

/**
 * callcenter所需服务
 * @author 何宁社
 *
 */
@Path("callcenter")
@Component
@Transactional
public class CallCenterService {
	@Autowired
	private SqlServer sqlServer;

	static Logger log = Logger.getLogger(CallCenterService.class);
	static String AUTH_URL;
	static String LOGIN_URL;
	static String VUE_URL;
	static String USER_URL;

	/**
	 * 根据活动名称获取业务逻辑内容
	 * @param process 流程名称
	 * @param activity 活动名称
	 * @return 业务逻辑内容
	 * @throws Exception
	 */
	@GET
	@Path("{process}/{activity}")
	public String getLogic(
			@PathParam("process") String process, @PathParam("activity") String activity) throws Exception {
		// 读取配置文件
		String ComponentDir="";
		//如果组件存放目录存在
		if(ThreadResource.ComponentDir.get().length()>0){
			ComponentDir="/"+ThreadResource.ComponentDir.get();
		}
		String config = ResourceHelper.getString(ComponentDir+"/callcenter/config.json");
		JSONObject json = new JSONObject(config);
		// 取对应的流程
		JSONObject processJson = json.getJSONObject(process);
		// 取活动对应的业务逻辑名
		String logicName = processJson.getString(activity);
		// 获取业务逻辑内容
		String result = ResourceHelper.getString(ComponentDir+"/callcenter/" + logicName);
		return result;
	}
	/**
	 * 根据活动名称获取业务逻辑内容
	 * @param process 流程名称
	 * @param activity 活动名称
	 * @return 业务逻辑内容
	 * @throws Exception
	 */
	@GET
	@Path("InitConfig")
	public String getIni() throws Exception {
		// 读取配置文件
		String ComponentDir="";
		//如果组件存放目录存在
		if(ThreadResource.ComponentDir.get().length()>0){
			ComponentDir="/"+ThreadResource.ComponentDir.get();
		}
		String config = ResourceHelper.getString(ComponentDir+"/XMS.INI");
		log.debug("获取的是"+ComponentDir+"分公司配置文件");
		return config;
	}

	@GET
	@Path("TelGroupConfig")
	public String getTelGroupConfig() throws Exception {
		System.out.println("获取话务分组");
		JSONArray rows = sqlServer.querySQL("SELECT value FROM t_singlevalue WHERE name = '话务分组'");
		JSONObject jsonObject = rows.getJSONObject(0);
		String value = jsonObject.getString("value");
		return  value;
	}

	@GET
	@Path("QxGroupConfig")
	public String getQxGroupConfig() throws Exception {
		System.out.println("获取抢险分组");
		JSONArray rows = sqlServer.querySQL("SELECT value FROM t_singlevalue WHERE name = '抢险分组'");
		JSONObject jsonObject = rows.getJSONObject(0);
		String value = jsonObject.getString("value");
		return  value;
	}
}
