package com.aote.plugin;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SendPost {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = LoggerFactory.getLogger( SendPost.class);

    private  SendPost(){

    }
    public static String sendPost(String url, String ak, String point_list,String rectify_option,String coord_type_output) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建参数列表
            List<NameValuePair> paramList = new ArrayList<>();
            paramList.add(new BasicNameValuePair("ak", ak));
            paramList.add(new BasicNameValuePair("point_list", point_list));
            paramList.add(new BasicNameValuePair("rectify_option", rectify_option));
            paramList.add(new BasicNameValuePair("coord_type_output", coord_type_output));
            // 模拟表单
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList,"utf-8");
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return resultString;
    }


}