package com.aote.plugin;

import com.af.plugins.RestTools;
import com.aote.sql.SqlServer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.*;

@Component
@Transactional
public class Public {

    private static Logger log = Logger.getLogger(Public.class);

    @Autowired
    private SqlServer sqlServer;

    public Public() {
    }

    public static String getNowTimeStamp() {
        return System.currentTimeMillis() + "";
    }

    public static String httpGet(String path, String token) {
        JSONObject headers = (new JSONObject()).put("x-access-token", token);
        return RestTools.get(path, headers.toString());
    }

    public static JSONArray stringToJsonArray(String str) {
        JSONArray jsonArray = null;
        try {
            if (StringUtils.isEmpty(str)) {
                return new JSONArray();
            }
            if (str.startsWith("[") && str.endsWith("]")) {
                return new JSONArray(str);
            }
            return new JSONArray(str.split(","));
        } catch (Exception ignored) {
            System.out.println(ignored.getMessage());
        } finally {
            jsonArray = new JSONArray();
        }
        return jsonArray;
    }

    /*
        表号：f_meternumber
        表向：f_aroundmeter
     */
    public JSONObject getFireData(JSONObject msg, JSONObject userfiles, JSONObject userfire) throws Exception {
        JSONObject fireData = new JSONObject();
        String userType = msg.getJSONArray("serviceacitivity")
                .getJSONObject(0)
                .getJSONObject("baseuserinfo")
                .getString("f_user_type");
        Map<String, String> columnMap = getColumnMap(userType);
        JSONObject userfilesUpdate = new JSONObject();
        JSONObject userfireUpdate = new JSONObject();

        JSONArray repairs = msg.getJSONArray("serviceacitivity")
                .getJSONObject(0)
                .getJSONArray("servicerepair");
        List<String> userfilesFields = new ArrayList<>(Arrays.asList("表前阀", "报警器", "表号", "初始表底数", "表封号", "表向",
                "流量计品牌", "流量计型号", "流量计类型", "流量范围(m³/h)"));
        int brandId = -1;
        for (int i = 0; i < repairs.length(); i++) {
            JSONObject repair = repairs.getJSONObject(i);
            JSONArray details = repair.getJSONArray("details");
            for (int j = 0; j < details.length(); j++) {
                JSONObject detail = details.getJSONObject(j);
                if (detail.has("f_content") && detail.get("f_content") != null) {
                    Object content = detail.get("f_content");
                    if ("气价名称".equals(detail.getString("f_project"))) {
                        JSONArray stairPrice =
                                sqlServer.query("select * from t_stairprice where f_price_name = '" + detail.get(
                                        "f_content") + "'");
                        if (stairPrice != null && stairPrice.length() > 0) {
                            int priceId = stairPrice.getJSONObject(0).getInt("f_price_id");
                            userfilesUpdate.put("f_price_id", priceId);
                        }
                    } else if ("气表品牌".equals(detail.getString("f_project"))) {
                        JSONArray gasBrand =
                                sqlServer.query("select * from t_gasbrand where f_meter_brand = '" + detail.get(
                                        "f_content") + "'");
                        if (gasBrand != null && gasBrand.length() > 0) {
                            brandId = gasBrand.getJSONObject(0).getInt("id");
                            String meterType = gasBrand.getJSONObject(0).getString("f_meter_type");
                            userfilesUpdate.put("f_gasbrand_id", brandId);
                            userfilesUpdate.put("f_meter_classify", meterType);
                        }
                    } else if ("气表型号".equals(detail.getString("f_project"))) {
                        if (brandId != -1) {
                            JSONArray gasModel = sqlServer.query("select * from t_gasmodel where f_meter_style = " +
                                    "'" + detail.get("f_content") + "' and f_gasbrand_id = " + brandId);
                            if (gasModel != null && gasModel.length() > 0) {
                                int modelId = gasModel.getJSONObject(0).getInt("id");
                                userfilesUpdate.put("f_gasmodel_id", modelId);
                            }
                        }
                    }
                    String column = columnMap.get(detail.getString("f_project"));
                    if (column != null) {
                        if (userfilesFields.contains(detail.getString("f_project"))) {
                            userfilesUpdate.put(column, content);
                        } else {
                            userfireUpdate.put(column, content);
                        }
                    }
                }
            }
        }
        if (!userfilesUpdate.isEmpty()) {
            userfilesUpdate.put("f_userfiles_id", userfiles.get("f_userfiles_id"));
            userfilesUpdate.put("version", userfiles.get("version"));
            fireData.put("userfiles", userfilesUpdate);
        }
        if (!userfireUpdate.isEmpty()) {
            userfireUpdate.put("id", userfire.get("id"));
            userfireUpdate.put("f_lgniter", msg.get("f_operator"));
            userfireUpdate.put("f_operator", msg.get("f_operator"));
            userfireUpdate.put("f_operatorid", msg.get("f_operatorid"));
            userfireUpdate.put("f_operate_date", msg.get("f_created_date"));
            fireData.put("userfire", userfireUpdate);
        }
        return fireData;
    }
    private Map<String, String> getColumnMap(String userType) {
        Map<String, String> map = new HashMap<>();
        if ("民用".equals(userType)) {
            map.put("镀锌管", "f_galvanize_pipe");
            map.put("三通", "f_tee");
            map.put("对丝", "f_nipple");
            map.put("弯头", "f_elbow");
            map.put("管卡", "f_pipe_strap");
            map.put("灶前阀", "f_zqf");
            map.put("胶管", "f_sebific_duct");
            map.put("自闭阀", "f_zbf");
            map.put("表前阀", "f_bqf_type");
            map.put("报警器", "f_alarm_code");
            map.put("灶具品牌", "f_gas_appliance");
            map.put("壁挂炉品牌", "f_bgl");
            map.put("热水器品牌", "f_geyser");

            map.put("表号", "f_meternumber");
            map.put("气表品牌", "f_fire_gasbrand");
            map.put("气表型号", "f_fire_gasmodel");
            map.put("初始表底数", "f_initial_base");
            map.put("表向", "f_aroundmeter");
            map.put("表封号", "f_metertitles");
        } else {
            map.put("流量计品牌", "f_flowmeter_brand");
            map.put("流量计型号", "f_flowmeter_model");
            map.put("流量计类型", "f_llj_type");
            map.put("流量范围(m³/h)", "f_llj_range");
            map.put("控制器品牌", "f_control_brand");
            map.put("控制器型号", "f_control_model");
            map.put("控制器编号", "f_control_code");
            map.put("灶具品牌", "f_appliance_brand");
            map.put("灶具型号", "f_appliance_model");

            map.put("表号", "f_meternumber");
            map.put("气表品牌", "f_fire_gasbrand");
            map.put("气表型号", "f_fire_gasmodel");
            map.put("初始表底数", "f_initial_base");
            map.put("表向", "f_aroundmeter");
            map.put("表封号", "f_metertitles");
        }
        return map;
    }
}