package com.aote.plugin;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Iterator;

public class JsonUtils {

    public static JSONObject getJsonObject (String str) {
        return new JSONObject(str);
    }

    public static JSONArray getJsonArray(String str) {
        return new JSONArray(str);
    }

    public static String defectContentConvertToDefectStr(String str) {
        final JSONObject jsonObject = getJsonObject(str);
        final JSONArray data = jsonObject.getJSONArray("data");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length(); i++) {
            JSONObject jsonObject1 = data.getJSONObject(i);
            final Iterator<String> keys = jsonObject1.keys();
            while (keys.hasNext()) {
                final String next = keys.next();
                stringBuilder.append(next);
                stringBuilder.append(":");
                stringBuilder.append(jsonObject1.optString(next));
                stringBuilder.append(";");
            }
        }
        return stringBuilder.toString();
    }

    public static String defectContentConvertToDefectStr(String str, int num) {
        StringBuilder stringBuilder = new StringBuilder();
        final String res = defectContentConvertToDefectStr(str);
        final String[] splitStr = res.split(";");
        for (String s : splitStr) {
            if (stringBuilder.toString().length() + s.length() > num) {
                return stringBuilder.toString();
            }
            stringBuilder.append(s);
        }
        return res;
    }

    public static JSONArray defectContentConvertToDefectArray(String str) {
        JSONArray jsonArray = new JSONArray();
        final String res = defectContentConvertToDefectStr(str);
        final String[] split = res.split(";");
        for (String s : split) {
            jsonArray.put(s);
        }
        return jsonArray;
    }

    /**
     * t_serviceworkorder表failure字段转存t_failure表
     * @param failureStr t_serviceworkorder 的 failure
     * @param f_service_id t_serviceworkorder 的 f_service_id
     * @return 可以存入t_failure表的jsonArray,需each后使用row来entity
     */
    public static JSONArray failureStrToFailureTable(String failureStr,String f_service_id){
        final JSONArray jsonArray = getJsonArray(failureStr.replaceAll("\\\\",""));
        JSONArray failures = new JSONArray();
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject failure = new JSONObject();
            JSONObject o = (JSONObject) jsonArray.get(i);
            System.out.println(o);
            final JSONArray failurecase = o.getJSONArray("failurecase");
            StringBuilder f_failure = new StringBuilder();
            for (int a = 0; a < failurecase.length(); a++) {
                f_failure.append(failurecase.get(a)).append(",");
            }
            failure.put("f_failure_type",o.getString("f_failure_type"));
            failure.put("f_failure",f_failure);
            failure.put("f_service_id",f_service_id);
            failures.put(failure);
        }
        return failures;
    }

}
