select
    tt.zhou,
    isnull(tt2.quanbujieting, 0)  quanbujieting,    --接听总量
    isnull(tt2.zongji, 0)         zongji, --呼入总量
    isnull(tt2.jietingzongsum, 0) jietingzongsum, --接听总量
    isnull(tt2.hursum, 0)         hursum --呼入总量
from (
         select '星期一' zhou
         union
         select '星期二' zhou
         union
         select '星期三' zhou
         union
         select '星期四' zhou
         union
         select '星期五' zhou
         union
         select '星期六' zhou
         union
         select '星期日' zhou
     ) tt
         left join (
    select  zhou,
            SUM(quanbujieting)                 AS quanbujieting,  --接听总量
            SUM(weijie) + SUM(yijie)           AS zongji,         --呼入总量
            SUM(shangquanbujieting)            AS jietingzongsum, --接听总量
            SUM(shangweijie) + SUM(shangyijie) AS hursum          --呼入总量
    from (
             SELECT datename(weekday, INLTIME) zhou,
                    COUNT(*) AS           quanbujieting,
                    0                     weijie,
                    0                     yijie,
                    0                     shangquanbujieting,
                    0                     shangweijie,
                    0                     shangyijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) != 0
               AND len(endtime) != 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),0)) --周
               AND INLTIME <= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
             union all
             SELECT datename(weekday, INLTIME) zhou,
                 0                     quanbujieting,
                 COUNT(*) AS           weijie,
                 0                     yijie,
                 0                     shangquanbujieting,
                 0                     shangweijie,
                 0                     shangyijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) = 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),0)) --周
               AND INLTIME <= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
             UNION ALL
             SELECT datename(weekday, INLTIME) zhou,
                 0                     quanbujieting,
                 0                     weijie,
                 COUNT(*) AS           yijie,
                 0                     shangquanbujieting,
                 0                     shangweijie,
                 0                     shangyijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) = 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),0)) --周
               AND INLTIME <= DATEADD(YEAR,0,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
             union all
             SELECT datename(weekday, INLTIME) zhou,
                 0                     quanbujieting,
                 0                     weijie,
                 0                     yijie,
                 COUNT(*) AS           shangquanbujieting,
                 0                     shangyijie,
                 0                     shangweijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) != 0
               AND len(endtime) != 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),0)) --上周
               AND INLTIME <= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
             UNION ALL
             SELECT datename(weekday, INLTIME) zhou,
                 0                     quanbujieting,
                 0                     weijie,
                 0                     yijie,
                 0                     shangquanbujieting,
                 COUNT(*) AS           shangweijie,
                 0                     shangyijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) = 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),0)) --上周
               AND INLTIME <= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
             UNION ALL
             SELECT datename(weekday, INLTIME) zhou,
                 0                     quanbujieting,
                 0                     weijie,
                 0                     yijie,
                 0                     shangquanbujieting,
                 0                     shangweijie,
                 COUNT(*) AS           shangyijie
             FROM t_records with (NOLOCK)
             WHERE len(starttime) != 0
               and teltype = '呼入'
               AND INLTIME >= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),0)) --上周
               AND INLTIME <= DATEADD(YEAR,-1,DATEADD(wk,datediff(wk,0,getdate()),7))
             GROUP BY datename(weekday, INLTIME)
         ) t
    group by zhou
) tt2 ON tt.zhou = tt2.zhou
order by
    replace(replace(replace(replace(replace(replace(replace(replace(tt.zhou,'一','1'),'二','2'),'三','3'),'四','4'),'五','5'),'六','6'),'日','7'),'星期','')




