SELECT
    *
FROM (
         SELECT
             tswo.*,
             tsw.f_date,
             tsw.f_name,
             tsw.f_date_come,
             tsw.f_date_leave,
             tsw.f_signname,
             tsw.f_sign_imgid,
             tsw.f_result_status,
             tsw.f_service_idea,
             sa.defname,
             sa.sender,
             CASE
                 WHEN tswo.f_workorder_type != '报修单' THEN -1
                 WHEN tsw.f_result_status = '已完成' THEN -1
                 WHEN tswo.f_finish_date = '' THEN -1
                 WHEN DATEDIFF( DAY, tswo.f_finish_date, GETDATE( ) ) < 0 THEN -1
                 ELSE DATEDIFF( DAY, tswo.f_finish_date, GETDATE( ) )
                 END overday,
             case when ISNULL(tswo.f_phone, '') != '' then tswo.f_phone else tu.f_user_phone end f_phone2
         FROM
             t_serviceworkorder tswo
                 LEFT JOIN ( SELECT * FROM t_servicework sw WHERE sw.id = ( SELECT MAX ( id ) FROM t_servicework WHERE serviceid = sw.serviceid ) ) tsw ON tswo.id= tsw.serviceid
                 LEFT JOIN ( SELECT * FROM ACTIVITYINS act WHERE act.id = ( SELECT MAX ( id ) FROM ACTIVITYINS WHERE PROCESSID = act.PROCESSID ) ) SA ON tswo.F_PROCESSID = sa.PROCESSID
                 LEFT JOIN AFproduct.dbo.t_userinfo tu on tswo.f_userinfo_id = tu.f_userinfo_id
     ) t
WHERE
    {condition}
ORDER BY
    f_created_date DESC
